/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.client.run_builders;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.SetMultimap;
import com.google.common.hash.HashCode;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.logging.Level;
import org.sosy_lab.verifiercloud.client.files.ClientFileStorage;
import org.sosy_lab.verifiercloud.client.run_builders.PathFilter;
import org.sosy_lab.verifiercloud.client.run_builders.RunCollectionBuilder;
import org.sosy_lab.verifiercloud.client.run_builders.RunCollectionCreationException;
import org.sosy_lab.verifiercloud.global.logging.Logger;
import org.sosy_lab.verifiercloud.global.util.FileUtils;
import org.sosy_lab.verifiercloud.transportable.collections.DefaultRunCollection;
import org.sosy_lab.verifiercloud.transportable.collections.RunCollection;
import org.sosy_lab.verifiercloud.transportable.collections.SchedulingPriority;
import org.sosy_lab.verifiercloud.transportable.file_hierarchy.FileAtRelativePath;
import org.sosy_lab.verifiercloud.transportable.file_hierarchy.FileHierarchy;
import org.sosy_lab.verifiercloud.transportable.file_hierarchy.string_based.DefaultFileAtRelativePath;
import org.sosy_lab.verifiercloud.transportable.file_hierarchy.tree_based.TreeFileHierarchyBuilder;
import org.sosy_lab.verifiercloud.transportable.run.Run;
import org.sosy_lab.verifiercloud.transportable.run.constraints.requirements.Requirements;

public abstract class AbstractFileRunCollectionBuilder
implements RunCollectionBuilder<RunCollectionCreationException> {
    private final Logger logger;
    private final ClientFileStorage clientFileStorage;
    private final Requirements requirements;
    private final Map<Path, Path> programFiles;
    private final Map<Path, Path> argumentFiles;
    private final SetMultimap<List<String>, List<Path>> commandArgumentFileSetMap;
    private final PathFilter programFilesFilter;
    private final ExecutorService threadPool;
    private Optional<String> name = Optional.absent();
    private SchedulingPriority priority = SchedulingPriority.LOW;

    public AbstractFileRunCollectionBuilder(Requirements requirements, ClientFileStorage clientFileStorage, PathFilter programFilesFilter, Logger logger) {
        this.requirements = Preconditions.checkNotNull(requirements);
        this.clientFileStorage = Preconditions.checkNotNull(clientFileStorage);
        this.programFilesFilter = Preconditions.checkNotNull(programFilesFilter);
        this.programFiles = Maps.newHashMap();
        this.argumentFiles = Maps.newHashMap();
        this.commandArgumentFileSetMap = HashMultimap.create();
        this.logger = Preconditions.checkNotNull(logger);
        ThreadFactoryBuilder tb = new ThreadFactoryBuilder().setNameFormat(this.getClass().getSimpleName() + "-pool-%d").setDaemon(true);
        int availableProcessors = Runtime.getRuntime().availableProcessors();
        this.threadPool = Executors.newFixedThreadPool(availableProcessors, tb.build());
    }

    public void addProgramFiles(Path file, Path relativeBaseDirectory) throws IOException {
        List<Path> allFiles = this.getAllFiles(Preconditions.checkNotNull(file), Preconditions.checkNotNull(relativeBaseDirectory));
        for (Path fileToAdd : allFiles) {
            if (!this.programFilesFilter.isPathMatched(fileToAdd)) continue;
            this.programFiles.put(fileToAdd, relativeBaseDirectory);
        }
    }

    protected void addInputFiles(List<String> command, Path file, Path relativeBaseDirectory) throws IOException {
        List<Path> allFiles = this.getAllFiles(file, relativeBaseDirectory);
        for (Path fileToAdd : allFiles) {
            ArrayList<Path> listOfFiles = Lists.newArrayListWithCapacity(1);
            listOfFiles.add(fileToAdd);
            this.commandArgumentFileSetMap.put(command, listOfFiles);
            this.argumentFiles.put(fileToAdd, relativeBaseDirectory);
        }
    }

    protected void addInputFiles(List<String> command, List<Path> paths, Path relativeBaseDirectory) throws IOException {
        ArrayList<Path> files = Lists.newArrayList();
        for (Path path : paths) {
            files.addAll(this.getAllFiles(path, relativeBaseDirectory));
        }
        for (Path fileToAdd : files) {
            Path previous = this.argumentFiles.put(fileToAdd, relativeBaseDirectory);
            Preconditions.checkState(previous == null || previous.equals(relativeBaseDirectory));
        }
        this.commandArgumentFileSetMap.put(command, files);
    }

    public void setName(String name) {
        Preconditions.checkNotNull(name);
        this.name = Optional.of(name);
    }

    private List<Path> getAllFiles(Path file, Path relativeBaseDirectory) throws IOException {
        Preconditions.checkNotNull(file);
        Preconditions.checkArgument(Files.exists(file, new LinkOption[0]), "File does not exist: %s", file);
        Preconditions.checkNotNull(relativeBaseDirectory);
        Preconditions.checkArgument(Files.isDirectory(relativeBaseDirectory, new LinkOption[0]));
        Preconditions.checkArgument(AbstractFileRunCollectionBuilder.isParentOf(relativeBaseDirectory, file), "%s is not a child of %s", file, relativeBaseDirectory);
        ArrayList<Path> allFiles = Lists.newArrayList();
        if (Files.isDirectory(file, new LinkOption[0])) {
            allFiles.addAll(FileUtils.recursiveFileList(file));
        } else {
            allFiles.add(file);
        }
        if (allFiles.isEmpty()) {
            throw new FileNotFoundException(file + " is not a valid file.");
        }
        return allFiles;
    }

    private static boolean isParentOf(Path dir, Path sub) {
        Path parentPath = dir.toAbsolutePath();
        Path path = sub.toAbsolutePath();
        return path.startsWith(parentPath);
    }

    private Iterable<FileAtRelativePath> hashProgramFiles() throws RunCollectionCreationException {
        ArrayList<FileAtRelativePath> result = Lists.newArrayListWithCapacity(this.programFiles.size());
        ArrayList<Future<FileAtRelativePath>> futures = Lists.newArrayListWithCapacity(this.programFiles.size());
        for (final Path path : this.programFiles.keySet()) {
            Future<FileAtRelativePath> future = this.threadPool.submit(new Callable<FileAtRelativePath>(){

                @Override
                public FileAtRelativePath call() throws Exception {
                    return AbstractFileRunCollectionBuilder.this.getFileAtRelativePathFromPath(path, (Path)AbstractFileRunCollectionBuilder.this.programFiles.get(path));
                }
            });
            futures.add(future);
        }
        for (Future future : futures) {
            try {
                FileAtRelativePath file = (FileAtRelativePath)future.get();
                result.add(file);
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RunCollectionCreationException(e);
            }
        }
        return result;
    }

    public void setPriority(SchedulingPriority priority) {
        this.priority = Preconditions.checkNotNull(priority);
    }

    @Override
    public RunCollection createRunCollection() throws RunCollectionCreationException {
        Preconditions.checkState(!this.argumentFiles.isEmpty(), "There are no input files.");
        this.logger.logf(Level.FINE, "Hashing files.", new Object[0]);
        Iterable<FileAtRelativePath> hashedProgramFiles = this.hashProgramFiles();
        ArrayList<Future<Run>> runFutures = Lists.newArrayList();
        this.logger.logf(Level.FINE, "Adding program files.", new Object[0]);
        final TreeFileHierarchyBuilder fileHierarchyBuilder = new TreeFileHierarchyBuilder();
        fileHierarchyBuilder.addProgramFiles(hashedProgramFiles);
        this.logger.logf(Level.FINE, "Creating runs.", new Object[0]);
        for (final List command : this.commandArgumentFileSetMap.keySet()) {
            for (final List<Path> paths : this.commandArgumentFileSetMap.get(command)) {
                Future<Run> runFuture = this.threadPool.submit(new Callable<Run>(){

                    @Override
                    public Run call() throws Exception {
                        ArrayList<FileAtRelativePath> relativeArgumentFiles = Lists.newArrayList();
                        for (Path path : paths) {
                            FileAtRelativePath relativeArgumentFile = AbstractFileRunCollectionBuilder.this.getFileAtRelativePathFromPath(path, (Path)AbstractFileRunCollectionBuilder.this.argumentFiles.get(path));
                            relativeArgumentFiles.add(relativeArgumentFile);
                        }
                        FileHierarchy fileHierarchy = fileHierarchyBuilder.buildForAgrumentFiles(relativeArgumentFiles);
                        Run run = AbstractFileRunCollectionBuilder.this.createRun(command, relativeArgumentFiles, fileHierarchy);
                        return run;
                    }
                });
                runFutures.add(runFuture);
            }
        }
        ArrayList<Run> runs = Lists.newArrayList();
        for (Future future : runFutures) {
            try {
                Run run = (Run)future.get();
                runs.add(run);
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RunCollectionCreationException(e);
            }
        }
        DefaultRunCollection.DefaultRunCollectionBuilder builder = DefaultRunCollection.forRuns(runs);
        builder.setInitialPriority(this.priority);
        builder.setRequirements(this.requirements);
        if (this.name.isPresent()) {
            builder.setName(this.name.get());
        }
        return builder.build();
    }

    protected abstract Run createRun(List<String> var1, List<FileAtRelativePath> var2, FileHierarchy var3);

    protected FileAtRelativePath getFileAtRelativePathFromPath(Path path, Path baseDir) throws RunCollectionCreationException {
        HashCode fileHash;
        if (!Files.exists(path, new LinkOption[0]) || !Files.isRegularFile(path, new LinkOption[0])) {
            throw new RunCollectionCreationException("File " + path.toAbsolutePath() + " does not exist.");
        }
        try {
            fileHash = this.clientFileStorage.pushFile(path.toAbsolutePath().normalize());
        }
        catch (IOException e) {
            throw new RunCollectionCreationException(e.getMessage());
        }
        Path absolutePath = path.toAbsolutePath().normalize();
        Path absoluteBaseDir = baseDir.toAbsolutePath().normalize();
        Preconditions.checkState(absolutePath.startsWith(absoluteBaseDir), "%s should start with %s", absolutePath, absoluteBaseDir);
        String relativePath = absoluteBaseDir.relativize(absolutePath).toString();
        return new DefaultFileAtRelativePath(fileHash, relativePath);
    }

    protected Logger getLogger() {
        return this.logger;
    }
}

