/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.client.run_builders;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.primitives.Ints;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.sosy_lab.verifiercloud.client.applications.benchmarking.Input;
import org.sosy_lab.verifiercloud.client.files.ClientFileStorage;
import org.sosy_lab.verifiercloud.client.run_builders.AbstractFileRunCollectionBuilder;
import org.sosy_lab.verifiercloud.client.run_builders.PathFilter;
import org.sosy_lab.verifiercloud.client.run_builders.RunCollectionCreationException;
import org.sosy_lab.verifiercloud.global.logging.Logger;
import org.sosy_lab.verifiercloud.transportable.collections.RunCollection;
import org.sosy_lab.verifiercloud.transportable.collections.SchedulingPriority;
import org.sosy_lab.verifiercloud.transportable.file_hierarchy.FileAtRelativePath;
import org.sosy_lab.verifiercloud.transportable.file_hierarchy.FileHierarchy;
import org.sosy_lab.verifiercloud.transportable.file_hierarchy.string_based.StringRelativePath;
import org.sosy_lab.verifiercloud.transportable.run.Run;
import org.sosy_lab.verifiercloud.transportable.run.RunBuilder;
import org.sosy_lab.verifiercloud.transportable.run.constraints.limitations.Limitations;
import org.sosy_lab.verifiercloud.transportable.run.constraints.limitations.LimitationsBuilder;
import org.sosy_lab.verifiercloud.transportable.run.filters.CompletePathFileFilter;
import org.sosy_lab.verifiercloud.transportable.run.filters.DisjunctiveFileFilter;
import org.sosy_lab.verifiercloud.transportable.run.filters.FileFilter;
import org.sosy_lab.verifiercloud.transportable.units.memory.MemoryUnit;
import org.sosy_lab.verifiercloud.transportable.units.time.TimeInterval;

public class BenchmarkRunCollectionBuilder
extends AbstractFileRunCollectionBuilder {
    @VisibleForTesting
    public static final TimeInterval MAX_TIME_LIMIT = TimeInterval.days(7L);
    private static final String NAME_FOR_RUNCOLLECTIONS = "benchmark";
    private final List<String> toolpaths;
    private Iterable<String> runDefinitionsLines;
    private final Path transerFilesBaseDir;
    private final Path relativeRunExceutorDir;
    private final Path workerResultFile;
    private final Optional<SchedulingPriority> priority;
    private Logger logger;
    private Map<List<String>, Limitations> commandToLimitationMap;
    private Map<List<String>, Path> commandToOutputFileNameMap;
    private Map<Run, Path> runToOutputFileNameMap;
    private final SimpleDateFormat sdf = new SimpleDateFormat("YY.MM.dd-HH:mm:ss");
    private final FileFilter outputFileFilter;

    public BenchmarkRunCollectionBuilder(ClientFileStorage clientFileStorage, Input input, PathFilter programFilesFilter, Path workerResultFile, Logger logger) {
        super(input.getRequirements(), clientFileStorage, programFilesFilter, logger);
        this.logger = Preconditions.checkNotNull(logger);
        Preconditions.checkNotNull(input);
        this.runDefinitionsLines = input.getRunDefinitions();
        this.toolpaths = input.getToolPaths();
        this.transerFilesBaseDir = input.getTransferFilesBaseDirectory();
        Path relativeRunExceutorDir = this.transerFilesBaseDir.relativize(input.getExecutingDir());
        this.relativeRunExceutorDir = relativeRunExceutorDir.equals(Paths.get("", new String[0])) ? Paths.get(".", new String[0]) : relativeRunExceutorDir;
        this.workerResultFile = workerResultFile;
        HashMap commandToLimitationMap = Maps.newHashMap();
        this.commandToLimitationMap = Collections.synchronizedMap(commandToLimitationMap);
        HashMap commandToOutputFileNameMap = Maps.newHashMap();
        this.commandToOutputFileNameMap = Collections.synchronizedMap(commandToOutputFileNameMap);
        HashMap runToOutputFileNameMap = Maps.newHashMap();
        this.runToOutputFileNameMap = Collections.synchronizedMap(runToOutputFileNameMap);
        Path outPutFile = relativeRunExceutorDir.resolve(workerResultFile);
        this.outputFileFilter = new DisjunctiveFileFilter(ImmutableList.of(new CompletePathFileFilter(outPutFile), input.getResultFilesFilter()));
        this.priority = input.getPriority();
    }

    @Override
    protected Run createRun(List<String> command, List<FileAtRelativePath> relativeArgumentFiles, FileHierarchy relativeRunFiles) {
        this.logger.logf(Level.FINEST, "Create run for %s.", command);
        Limitations limitations = this.commandToLimitationMap.get(command);
        Run run = RunBuilder.forCommand(command).setWorkerResultFile(StringRelativePath.from(this.workerResultFile)).addFiles(relativeRunFiles).setLimitations(limitations).setOutputFilePattern(this.outputFileFilter).setExecutionPath(StringRelativePath.from(this.relativeRunExceutorDir)).build();
        this.runToOutputFileNameMap.put(run, this.commandToOutputFileNameMap.get(command));
        return run;
    }

    @Override
    public RunCollection createRunCollection() throws RunCollectionCreationException {
        Iterator<String> it = this.runDefinitionsLines.iterator();
        this.logger.logf(Level.FINER, "Adding programm files.", new Object[0]);
        for (String toolPath : this.toolpaths) {
            try {
                this.addProgramFiles(Paths.get(toolPath, new String[0]), this.transerFilesBaseDir);
            }
            catch (IOException | IllegalArgumentException e) {
                throw new RunCollectionCreationException(e);
            }
        }
        while (it.hasNext()) {
            String[] commandLineTokens = it.next().split("\\t");
            Optional<Integer> numberOfRuns = Optional.fromNullable(Ints.tryParse(commandLineTokens[0]));
            this.handleABlockOfRunInformation(it, commandLineTokens, numberOfRuns);
        }
        this.logger.logf(Level.INFO, "Creating run collection.", new Object[0]);
        super.setName("benchmark_" + this.sdf.format(new Date()));
        if (this.priority.isPresent()) {
            super.setPriority(this.priority.get());
        }
        RunCollection runCollection = super.createRunCollection();
        return runCollection;
    }

    private void handleABlockOfRunInformation(Iterator<String> it, String[] blockLineTokens, Optional<Integer> numberOfRuns) throws RunCollectionCreationException {
        if (!numberOfRuns.isPresent() || blockLineTokens.length < 3) {
            throw new RunCollectionCreationException("Invalid block head line input format");
        }
        String[] limitationTokens = Arrays.copyOfRange(blockLineTokens, 1, blockLineTokens.length);
        Limitations limitations = this.getLimitations(limitationTokens);
        this.addRunInformationForABlock(it, numberOfRuns.get(), limitations);
    }

    private void addRunInformationForABlock(Iterator<String> it, int numberOfRuns, Limitations limitations) throws RunCollectionCreationException {
        for (int i = 0; i < numberOfRuns; ++i) {
            if (!it.hasNext()) continue;
            String[] tokens = it.next().split("\\t");
            if (tokens.length >= 3) {
                String command = tokens[0];
                Path outputFile = Paths.get(tokens[1], new String[0]);
                ArrayList<Path> newFiles = Lists.newArrayList();
                for (int j = 2; j < tokens.length; ++j) {
                    newFiles.add(Paths.get(tokens[j], new String[0]));
                }
                this.logger.logf(Level.FINEST, "Adding information for run using command: %s", command);
                this.addInformationForARun(limitations, newFiles, command, outputFile);
                continue;
            }
            throw new RunCollectionCreationException("End of input reached without number of given run definitions. Given number in head line of block: " + numberOfRuns);
        }
    }

    private void addInformationForARun(Limitations limitations, List<Path> newFiles, String command, Path outputFile) throws RunCollectionCreationException {
        try {
            ImmutableList<String> commandAsList = ImmutableList.of(command);
            this.addInputFiles(commandAsList, newFiles, this.transerFilesBaseDir);
            this.commandToLimitationMap.put(commandAsList, limitations);
            this.commandToOutputFileNameMap.put(commandAsList, outputFile);
        }
        catch (IOException | IllegalArgumentException e) {
            throw new RunCollectionCreationException(e.getMessage());
        }
    }

    private Limitations getLimitations(String[] limitationStrings) throws NumberFormatException, RunCollectionCreationException {
        LimitationsBuilder builder;
        if (limitationStrings.length >= 2) {
            TimeInterval timeLimit = this.getTimelimit(limitationStrings[0]);
            builder = LimitationsBuilder.from(timeLimit);
            if (!limitationStrings[1].equals("None")) {
                int memory = Integer.parseInt(limitationStrings[1]);
                MemoryUnit memoryLimit = MemoryUnit.megabyte(memory);
                builder.setMemoryLimit(memoryLimit);
            }
            if (limitationStrings.length >= 3) {
                int coreLimit = Integer.parseInt(limitationStrings[2]);
                builder.setCoreLimit(coreLimit);
            }
        } else {
            throw new RunCollectionCreationException("Not enough limitation arguments");
        }
        return builder.build();
    }

    private TimeInterval getTimelimit(String limitationStrings) {
        Long time = Long.parseLong(limitationStrings);
        TimeInterval timeLimit = TimeInterval.seconds(time);
        if (timeLimit.compareTo(MAX_TIME_LIMIT) > 0) {
            this.logger.logf(Level.WARNING, "Time limit %s is to high. %s ist used.", timeLimit, MAX_TIME_LIMIT);
            timeLimit = MAX_TIME_LIMIT;
        }
        return timeLimit;
    }

    public Map<Run, Path> getRunToOutputFileNameMap() {
        return ImmutableMap.copyOf(this.runToOutputFileNameMap);
    }
}

