/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.client.run_builders;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import org.sosy_lab.verifiercloud.client.files.ClientFileStorage;
import org.sosy_lab.verifiercloud.client.run_builders.AbstractFileRunCollectionBuilder;
import org.sosy_lab.verifiercloud.client.run_builders.AllPathsFilter;
import org.sosy_lab.verifiercloud.global.logging.Logger;
import org.sosy_lab.verifiercloud.transportable.file_hierarchy.FileAtRelativePath;
import org.sosy_lab.verifiercloud.transportable.file_hierarchy.FileHierarchy;
import org.sosy_lab.verifiercloud.transportable.file_hierarchy.RelativePath;
import org.sosy_lab.verifiercloud.transportable.file_hierarchy.string_based.StringRelativePath;
import org.sosy_lab.verifiercloud.transportable.run.Run;
import org.sosy_lab.verifiercloud.transportable.run.RunBuilder;
import org.sosy_lab.verifiercloud.transportable.run.constraints.limitations.Limitations;
import org.sosy_lab.verifiercloud.transportable.run.constraints.requirements.Requirements;
import org.sosy_lab.verifiercloud.transportable.run.filters.FileFilter;

public class MultiFileRunCollectionBuilder
extends AbstractFileRunCollectionBuilder {
    private final List<String> command;
    private final Limitations limitations;
    private final Path relativeRunExecutionPath;
    private final RelativePath outputFile;
    private final FileFilter outputFiles;
    private Optional<String> annotation = Optional.absent();

    public MultiFileRunCollectionBuilder(List<String> command, ClientFileStorage clientFileStorage, Limitations limitations, Requirements requirements, Path relativeRunExecutionPath, RelativePath outputFile, FileFilter outputFiles, Logger logger) {
        super(requirements, clientFileStorage, new AllPathsFilter(), logger);
        this.relativeRunExecutionPath = Preconditions.checkNotNull(relativeRunExecutionPath);
        this.command = Preconditions.checkNotNull(command);
        Preconditions.checkArgument(!command.isEmpty(), "Empty commands are not allowed.");
        this.limitations = Preconditions.checkNotNull(limitations);
        this.outputFiles = Preconditions.checkNotNull(outputFiles);
        this.outputFile = Preconditions.checkNotNull(outputFile);
    }

    public void addInputFiles(Path file, Path relativeBaseDirectory) throws IOException {
        super.addInputFiles(this.command, file, relativeBaseDirectory);
    }

    public void setAnnotation(String annotation) {
        this.annotation = Optional.of(annotation);
    }

    @Override
    protected Run createRun(List<String> command, List<FileAtRelativePath> relativeArgumentFiles, FileHierarchy relativeRunFiles) {
        ImmutableList.Builder commandBuilder = ImmutableList.builder();
        commandBuilder.addAll(command);
        RelativePath relativeExecutionPath = this.relativeRunExecutionPath.equals(Paths.get("", new String[0])) ? StringRelativePath.from(".") : StringRelativePath.from(this.relativeRunExecutionPath);
        for (FileAtRelativePath relativeArgumentFile : relativeArgumentFiles) {
            StringBuilder argumentFilePath = new StringBuilder();
            for (Path pathPart : this.relativeRunExecutionPath) {
                if (pathPart.equals(Paths.get("", new String[0])) || pathPart.equals(Paths.get(".", new String[0]))) continue;
                argumentFilePath.append("../");
            }
            argumentFilePath.append(relativeArgumentFile.getRelativePath());
            commandBuilder.add(argumentFilePath.toString());
        }
        RunBuilder builder = RunBuilder.forCommand((List<String>)((Object)commandBuilder.build())).setLimitations(this.limitations).setOutputFilePattern(this.outputFiles).addFiles(relativeRunFiles).setExecutionPath(relativeExecutionPath).setWorkerResultFile(this.outputFile);
        if (this.annotation.isPresent()) {
            builder.setDescription(this.annotation.get());
        }
        return builder.build();
    }
}

