/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.client.run_builders;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.sosy_lab.verifiercloud.client.run_builders.RunCollectionBuilder;
import org.sosy_lab.verifiercloud.client.run_builders.RunCollectionCreationException;
import org.sosy_lab.verifiercloud.transportable.collections.DefaultRunCollection;
import org.sosy_lab.verifiercloud.transportable.collections.RunCollection;
import org.sosy_lab.verifiercloud.transportable.collections.SchedulingPriority;
import org.sosy_lab.verifiercloud.transportable.file_hierarchy.RelativePath;
import org.sosy_lab.verifiercloud.transportable.file_hierarchy.string_based.StringRelativePath;
import org.sosy_lab.verifiercloud.transportable.run.Run;
import org.sosy_lab.verifiercloud.transportable.run.RunBuilder;

public class TrivialTestRunCollectionBuilder
implements RunCollectionBuilder<RunCollectionCreationException> {
    private final RelativePath outputFileName;

    public TrivialTestRunCollectionBuilder(RelativePath outputFileName) {
        this.outputFileName = Preconditions.checkNotNull(outputFileName);
    }

    public TrivialTestRunCollectionBuilder() {
        this.outputFileName = StringRelativePath.from("output.txt");
    }

    @Override
    public RunCollection createRunCollection() {
        ArrayList<Run> runs = Lists.newArrayList();
        runs.add(this.dfRun());
        runs.add(this.longRun());
        runs.add(this.pwdRun());
        return DefaultRunCollection.forRuns(runs).setInitialPriority(SchedulingPriority.HIGH).build();
    }

    private Run dfRun() {
        ImmutableList<String> trivialCommand = ImmutableList.of("df", "-h");
        return this.buildRun(trivialCommand);
    }

    private Run longRun() {
        ImmutableCollection command = ((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().add(new String[]{"for", "i", "in", "`seq 1 60`;"})).add(new String[]{"do", "echo", "$i;"})).add(new String[]{"sleep 1;", "done;", "echo", "finished"})).build();
        return this.buildRun((List<String>)((Object)command));
    }

    private Run pwdRun() {
        ImmutableList<String> command = ImmutableList.of("pwd");
        return this.buildRun(command);
    }

    private Run buildRun(List<String> command) {
        return RunBuilder.forCommand(command).setWorkerResultFile(this.outputFileName).build();
    }
}

