/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.client.run_builders.web;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.sosy_lab.verifiercloud.client.applications.webclient.git_handling.GitManager;
import org.sosy_lab.verifiercloud.client.applications.webclient.program_files.ProgramFilesProvider;
import org.sosy_lab.verifiercloud.client.applications.webclient.run_infomation.StartRunInformation;
import org.sosy_lab.verifiercloud.client.files.WebClientFileStorage;
import org.sosy_lab.verifiercloud.client.run_builders.web.WebRunCollectionBuilder;
import org.sosy_lab.verifiercloud.client.run_builders.web.WebRunCollectionBuilderFactory;
import org.sosy_lab.verifiercloud.global.logging.Logger;
import org.sosy_lab.verifiercloud.global.permanent_storage.exceptions.PermanentStorageException;
import org.sosy_lab.verifiercloud.transportable.collections.SchedulingPriority;

public class DefaultWebRunCollectionBuilderFactory
implements WebRunCollectionBuilderFactory {
    private final AtomicBoolean initialiezed = new AtomicBoolean(false);
    private final WebClientFileStorage clientFileStorage;
    private final ProgramFilesProvider programFilesProvider;
    private final GitManager gitManager;
    private final Logger logger;
    private final ImmutableList<String> toolCommand;
    private final SchedulingPriority normalPriority;
    private final SchedulingPriority premiumPriority;

    @Inject
    public DefaultWebRunCollectionBuilderFactory(WebClientFileStorage clientFileStorage, ProgramFilesProvider programFilesProvider, GitManager gitManager, Logger logger, @Named(value="command") ImmutableList<String> toolCommand, @Named(value="normalPriority") SchedulingPriority normalPriority, @Named(value="premiumPriority") SchedulingPriority premiumPriority) {
        this.clientFileStorage = Preconditions.checkNotNull(clientFileStorage);
        this.gitManager = Preconditions.checkNotNull(gitManager);
        this.logger = Preconditions.checkNotNull(logger);
        this.toolCommand = Preconditions.checkNotNull(toolCommand);
        this.programFilesProvider = Preconditions.checkNotNull(programFilesProvider);
        this.normalPriority = Preconditions.checkNotNull(normalPriority);
        this.premiumPriority = Preconditions.checkNotNull(premiumPriority);
    }

    @Override
    public void initialize() throws IOException, GitAPIException, PermanentStorageException {
        Preconditions.checkState(!this.initialiezed.getAndSet(true));
        this.programFilesProvider.initialize();
    }

    @Override
    public void cleanUp() {
        this.programFilesProvider.cleanUp();
    }

    public WebRunCollectionBuilder createWebRunCollectionBuilder(StartRunInformation startRunInformation) {
        Preconditions.checkState(this.initialiezed.get());
        return new WebRunCollectionBuilder(startRunInformation, this.toolCommand, this.normalPriority, this.premiumPriority, this.programFilesProvider, this.gitManager, this.clientFileStorage, this.logger);
    }
}

