/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.client.run_builders.web;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.jgit.api.errors.RefNotFoundException;
import org.sosy_lab.verifiercloud.client.applications.webclient.git_handling.GitManager;
import org.sosy_lab.verifiercloud.client.applications.webclient.program_files.ProgramFilesProvider;
import org.sosy_lab.verifiercloud.client.applications.webclient.run_infomation.StartRunInformation;
import org.sosy_lab.verifiercloud.client.applications.webclient.run_infomation.svn_revision.ImmutableSvnRevision;
import org.sosy_lab.verifiercloud.client.applications.webclient.run_infomation.svn_revision.SvnRevision;
import org.sosy_lab.verifiercloud.client.files.WebClientFileStorage;
import org.sosy_lab.verifiercloud.client.run_builders.RunCollectionBuilder;
import org.sosy_lab.verifiercloud.client.run_builders.RunCollectionCreationException;
import org.sosy_lab.verifiercloud.global.logging.Logger;
import org.sosy_lab.verifiercloud.transportable.collections.DefaultRunCollection;
import org.sosy_lab.verifiercloud.transportable.collections.RunCollection;
import org.sosy_lab.verifiercloud.transportable.collections.SchedulingPriority;
import org.sosy_lab.verifiercloud.transportable.file_hierarchy.FileAtRelativePath;
import org.sosy_lab.verifiercloud.transportable.file_hierarchy.FileHierarchy;
import org.sosy_lab.verifiercloud.transportable.file_hierarchy.RelativePath;
import org.sosy_lab.verifiercloud.transportable.file_hierarchy.string_based.DefaultFileAtRelativePath;
import org.sosy_lab.verifiercloud.transportable.file_hierarchy.string_based.StringRelativePath;
import org.sosy_lab.verifiercloud.transportable.file_hierarchy.tree_based.TreeFileHierarchyBuilder;
import org.sosy_lab.verifiercloud.transportable.filecontent.ZipFileContent;
import org.sosy_lab.verifiercloud.transportable.run.Run;
import org.sosy_lab.verifiercloud.transportable.run.RunBuilder;
import org.sosy_lab.verifiercloud.transportable.run.constraints.limitations.Limitations;
import org.sosy_lab.verifiercloud.transportable.run.constraints.requirements.Requirements;
import org.sosy_lab.verifiercloud.transportable.run.constraints.requirements.RequirementsBuilder;
import org.sosy_lab.verifiercloud.transportable.run.filters.AllFileFilter;
import org.sosy_lab.verifiercloud.transportable.units.memory.MemoryUnit;

public class WebRunCollectionBuilder
implements RunCollectionBuilder<RefNotFoundException> {
    private static final RelativePath LOG_FILE_NAME = StringRelativePath.from("output.log");
    private static final String SPEC = "-spec";
    private static final String SET_PROPERTY = "-setprop";
    private static final String MAX_HEAP_SIZE = "-heap";
    private static final String DISABLE_JAVA_ASSERTIONS = "-disable-java-assertions";
    protected static final Path SPEC_FILE_NAME = Paths.get("VCLOUD_CLIENT_SPEC_FILE.spc", new String[0]);
    protected static final Path PROP_FILE_NAME = Paths.get("VCLOUD_CLIENT_PROP_FILE.prp", new String[0]);
    protected static final Path WITNESS_FILE_NAME = Paths.get("VCLOUD_CLIENT_ERROR_WITNESS_FILE.graphml", new String[0]);
    private final Logger logger;
    private final WebClientFileStorage clientFileStorage;
    private final GitManager gitManager;
    private final ProgramFilesProvider programFilesProvider;
    private final StartRunInformation startRunInformation;
    private final ImmutableList<String> toolCommand;
    private final SchedulingPriority normalPriority;
    private final SchedulingPriority premiumPriority;

    public WebRunCollectionBuilder(StartRunInformation startRunInformation, ImmutableList<String> toolCommand, SchedulingPriority normalPriority, SchedulingPriority premiumPriority, ProgramFilesProvider programFilesProvider, GitManager gitManager, WebClientFileStorage clientFileStorage, Logger logger) {
        this.logger = Preconditions.checkNotNull(logger);
        this.startRunInformation = Preconditions.checkNotNull(startRunInformation);
        this.programFilesProvider = Preconditions.checkNotNull(programFilesProvider);
        this.gitManager = Preconditions.checkNotNull(gitManager);
        this.toolCommand = Preconditions.checkNotNull(toolCommand);
        this.clientFileStorage = Preconditions.checkNotNull(clientFileStorage);
        this.normalPriority = Preconditions.checkNotNull(normalPriority);
        this.premiumPriority = Preconditions.checkNotNull(premiumPriority);
    }

    @Override
    public RunCollection createRunCollection() throws RunCollectionCreationException, RefNotFoundException {
        Optional<Path> relativeErrorWitnessPath;
        Optional<Path> relativePropPath;
        Optional<Path> relativeSpecPath;
        this.logger.logf(Level.FINE, "Creating run collection.", new Object[0]);
        SvnRevision revision = this.startRunInformation.getSvnRevision();
        TreeFileHierarchyBuilder fileHierarchyBuilder = this.programFilesProvider.getProgramFiles(revision);
        ArrayList<FileAtRelativePath> runSpecificFiles = Lists.newArrayList();
        if (this.startRunInformation.getSpecificationText().isPresent()) {
            relativeSpecPath = Optional.of(SPEC_FILE_NAME);
            FileAtRelativePath specfile = this.addToFileStorage(this.startRunInformation.getSpecificationText().get(), SPEC_FILE_NAME);
            runSpecificFiles.add(specfile);
        } else {
            relativeSpecPath = Optional.absent();
        }
        if (this.startRunInformation.getPropertyText().isPresent()) {
            relativePropPath = Optional.of(PROP_FILE_NAME);
            FileAtRelativePath propfile = this.addToFileStorage(this.startRunInformation.getPropertyText().get(), PROP_FILE_NAME);
            runSpecificFiles.add(propfile);
        } else {
            relativePropPath = Optional.absent();
        }
        if (this.startRunInformation.getErrorWitnessText().isPresent()) {
            relativeErrorWitnessPath = Optional.of(WITNESS_FILE_NAME);
            FileAtRelativePath errorWitnessFile = this.addToFileStorage(this.startRunInformation.getErrorWitnessText().get(), WITNESS_FILE_NAME);
            runSpecificFiles.add(errorWitnessFile);
        } else {
            relativeErrorWitnessPath = Optional.absent();
        }
        for (Map.Entry file : this.startRunInformation.getProgramTexts().entrySet()) {
            FileAtRelativePath argumentFile = this.addToFileStorage((String)file.getValue(), (Path)file.getKey());
            runSpecificFiles.add(argumentFile);
        }
        FileHierarchy relativeRunFiles = fileHierarchyBuilder.buildForAgrumentFiles(runSpecificFiles);
        List<String> command = this.buildCommand(this.startRunInformation.getProgramTexts(), relativeSpecPath, relativePropPath, relativeErrorWitnessPath);
        Run run = this.createRun(command, relativeRunFiles);
        Requirements requirements = this.getRequirements(this.startRunInformation.getLimitations(), this.startRunInformation.getCpuModel());
        return DefaultRunCollection.forRuns(Lists.newArrayList(run)).setInitialPriority(this.getPriority()).setRequirements(requirements).setName("webclient run").setUserName(this.startRunInformation.getUserName()).build();
    }

    private SchedulingPriority getPriority() {
        if (this.startRunInformation.isPremiumUserPriority()) {
            return this.premiumPriority;
        }
        return this.normalPriority;
    }

    private Run createRun(List<String> command, FileHierarchy relativeRunFiles) throws RunCollectionCreationException {
        ImmutableSvnRevision currentSvnRevision;
        SvnRevision svnRevision = this.startRunInformation.getSvnRevision();
        try {
            currentSvnRevision = svnRevision.getCurrentRevision(this.gitManager);
        }
        catch (IOException | RefNotFoundException e) {
            throw new RunCollectionCreationException(e);
        }
        Limitations limitations = this.startRunInformation.getLimitations();
        return RunBuilder.forCommand(command).setLimitations(limitations).addFiles(relativeRunFiles).setOutputFilePattern(new AllFileFilter()).storeResultOnMaster().setWorkerResultFile(LOG_FILE_NAME).setDescription("CPAchecker " + currentSvnRevision).build();
    }

    private Requirements getRequirements(Limitations limitations, Optional<String> cpuModel) {
        Preconditions.checkArgument(limitations.getProcessorLimit().isPresent());
        Preconditions.checkArgument(limitations.getMemoryLimit().isPresent());
        int cpuCoreLimit = limitations.getProcessorLimit().get();
        MemoryUnit memoryRequirements = limitations.getMemoryLimit().get();
        RequirementsBuilder builder = RequirementsBuilder.withProcessors(cpuCoreLimit).requireCgroups().setMemoryRequirements(memoryRequirements);
        if (cpuModel.isPresent()) {
            builder.setCpuRequirements(cpuModel.get());
        }
        return builder.build();
    }

    private FileAtRelativePath addToFileStorage(String fileContentasString, Path relativePath) throws RunCollectionCreationException {
        ZipFileContent fileContent;
        try {
            fileContent = ZipFileContent.fromString(fileContentasString);
        }
        catch (IOException e) {
            throw new RunCollectionCreationException(e);
        }
        DefaultFileAtRelativePath fileAtRelativePath = new DefaultFileAtRelativePath(fileContent.getFileHash(), relativePath.toString());
        try {
            this.clientFileStorage.pushFile(fileContent);
        }
        catch (IOException e) {
            throw new RunCollectionCreationException(e);
        }
        return fileAtRelativePath;
    }

    private List<String> buildCommand(ImmutableMap<Path, String> argumentFiles, Optional<Path> relativeSpecFile, Optional<Path> relativePropPath, Optional<Path> relativeErrorWitnessPath) {
        Optional<MemoryUnit> maxHeapSize;
        Optional<String> configuration;
        Optional<String> specification;
        ImmutableList.Builder commandBuilder = ImmutableList.builder();
        commandBuilder.addAll(this.toolCommand);
        for (String property : this.startRunInformation.getAdditionalOptions()) {
            ((ImmutableList.Builder)commandBuilder.add(SET_PROPERTY)).add(property);
        }
        if (relativeSpecFile.isPresent()) {
            ((ImmutableList.Builder)commandBuilder.add(SPEC)).add(relativeSpecFile.get().toString());
        }
        if (relativePropPath.isPresent()) {
            ((ImmutableList.Builder)commandBuilder.add(SPEC)).add(relativePropPath.get().toString());
        }
        if (relativeErrorWitnessPath.isPresent()) {
            ((ImmutableList.Builder)commandBuilder.add(SPEC)).add(relativeErrorWitnessPath.get().toString());
        }
        if ((specification = this.startRunInformation.getSpecification()).isPresent()) {
            ((ImmutableList.Builder)commandBuilder.add(SPEC)).add(specification.get());
        }
        if ((configuration = this.startRunInformation.getConfiguration()).isPresent()) {
            commandBuilder.add('-' + configuration.get());
        }
        if ((maxHeapSize = this.startRunInformation.getMaxHeapSize()).isPresent()) {
            String maxHeapSizeString = Long.toString(maxHeapSize.get().toByte());
            ((ImmutableList.Builder)commandBuilder.add(MAX_HEAP_SIZE)).add(maxHeapSizeString);
        }
        if (this.startRunInformation.disableJavaAssertions()) {
            commandBuilder.add(DISABLE_JAVA_ASSERTIONS);
        }
        for (Path argumentFileName : argumentFiles.keySet()) {
            commandBuilder.add(argumentFileName.toString());
        }
        return commandBuilder.build();
    }
}

