/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.client.run_storage;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.CheckedFuture;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.SettableFuture;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.sosy_lab.verifiercloud.client.network.exceptions.RunCanceledException;
import org.sosy_lab.verifiercloud.client.run_storage.ClientRunStorage;
import org.sosy_lab.verifiercloud.transportable.collections.RunCollection;
import org.sosy_lab.verifiercloud.transportable.run.Run;
import org.sosy_lab.verifiercloud.transportable.run.RunResult;

@Singleton
public class MemClientRunStorage
implements ClientRunStorage {
    private final Map<Run, SettableFuture<RunResult>> futureResults;

    @Inject
    public MemClientRunStorage() {
        HashMap unsyncMap = Maps.newHashMap();
        this.futureResults = Collections.synchronizedMap(unsyncMap);
    }

    @Override
    public synchronized List<CheckedFuture<RunResult, RunCanceledException>> addRunCollection(RunCollection runCollection) {
        Preconditions.checkNotNull(runCollection);
        ArrayList<CheckedFuture<RunResult, RunCanceledException>> resultFutures = Lists.newArrayList();
        for (Run run : runCollection.getRuns()) {
            resultFutures.add(this.getAndCreateFutureRunResult(run));
        }
        return resultFutures;
    }

    @Override
    public synchronized void addRunResult(Run run, RunResult runResult) {
        Preconditions.checkNotNull(run);
        Preconditions.checkNotNull(runResult);
        Preconditions.checkArgument(this.futureResults.containsKey(run));
        Preconditions.checkArgument(!this.futureResults.get(run).isDone());
        Preconditions.checkArgument(runResult.getRun().equals(run));
        this.futureResults.get(run).set(runResult);
        this.futureResults.remove(run);
    }

    private synchronized CheckedFuture<RunResult, RunCanceledException> getAndCreateFutureRunResult(Run run) {
        Preconditions.checkNotNull(run);
        Preconditions.checkArgument(!this.futureResults.containsKey(run));
        SettableFuture futureRunResult = SettableFuture.create();
        CheckedFuture<RunResult, RunCanceledException> returnFuture = Futures.makeChecked(futureRunResult, new Function<Exception, RunCanceledException>(){

            @Override
            public RunCanceledException apply(Exception input) {
                return new RunCanceledException(input);
            }
        });
        this.futureResults.put(run, futureRunResult);
        return returnFuture;
    }

    @Override
    public synchronized void markAsCanceled(Run run, Exception reason) {
        Preconditions.checkNotNull(reason);
        Preconditions.checkNotNull(run);
        SettableFuture<RunResult> future = this.futureResults.remove(run);
        Preconditions.checkArgument(future != null, "Cannot cancel unkown run: %s", run);
        future.setException(reason);
    }

    @Override
    public synchronized void markAllAsCanceled(Exception reason) {
        Preconditions.checkNotNull(reason);
        for (SettableFuture<RunResult> futureResult : this.futureResults.values()) {
            futureResult.setException(reason);
        }
        this.futureResults.clear();
    }
}

