/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.global.application;

import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.sosy_lab.verifiercloud.global.application.CommandLineArguments;

public class DefaultCommandLineArguments
implements CommandLineArguments {
    private final ImmutableMap<String, String> namedArguments;
    private final ImmutableList<String> positionalArguments;

    public DefaultCommandLineArguments(Map<String, String> namedArguments, List<String> positionalArguments) {
        this.namedArguments = ImmutableMap.copyOf(namedArguments);
        this.positionalArguments = ImmutableList.copyOf(positionalArguments);
    }

    @Override
    public Map<String, String> getNamedArguments() {
        return this.namedArguments;
    }

    @Override
    public List<String> getPositionalArguments() {
        return this.positionalArguments;
    }

    @Override
    public CommandLineArguments removeNamedArguments(Set<String> args) {
        Map<String, String> filteredNamedArguments = Maps.filterKeys(this.namedArguments, Predicates.not(Predicates.in(args)));
        return new DefaultCommandLineArguments(filteredNamedArguments, this.positionalArguments);
    }

    @Override
    public boolean isEmpty() {
        return this.namedArguments.isEmpty() && this.positionalArguments.isEmpty();
    }

    public int hashCode() {
        return Objects.hash(this.namedArguments, this.positionalArguments);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CommandLineArguments)) {
            return false;
        }
        CommandLineArguments other = (CommandLineArguments)obj;
        return this.getNamedArguments().equals(other.getNamedArguments()) && this.getPositionalArguments().equals(other.getPositionalArguments());
    }

    public String toString() {
        return "[named arguments: " + this.namedArguments + ", positional arguments" + this.positionalArguments + "]";
    }
}

