/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.global.application;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import java.util.logging.Level;
import org.sosy_lab.verifiercloud.global.application.ApplicationService;
import org.sosy_lab.verifiercloud.global.logging.Logger;
import org.sosy_lab.verifiercloud.global.util.error_trigger.ErrorTriggerExecutor;

public class ExecuteErrorTriggerUncaughtExceptionHandler
implements Thread.UncaughtExceptionHandler {
    private final ErrorTriggerExecutor errorTriggerExecutor;
    private final Logger logger;

    @Inject
    public ExecuteErrorTriggerUncaughtExceptionHandler(ApplicationService app, ErrorTriggerExecutor errorTriggerExecutor, Logger logger) {
        this.errorTriggerExecutor = Preconditions.checkNotNull(errorTriggerExecutor);
        this.logger = Preconditions.checkNotNull(logger);
    }

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        this.logger.logf(Level.SEVERE, "Uncaught exception in thread %s: %s", t.getName(), e.getMessage());
        this.errorTriggerExecutor.executeErrorTriggerForUncaughtException(t, e);
    }
}

