/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.global.application;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import java.util.logging.Level;
import org.sosy_lab.verifiercloud.global.application.ApplicationService;
import org.sosy_lab.verifiercloud.global.logging.Logger;

public class StopApplicationUncaughtExceptionHandler
implements Thread.UncaughtExceptionHandler {
    private ApplicationService app;
    private Logger logger;

    @Inject
    public StopApplicationUncaughtExceptionHandler(ApplicationService app, Logger logger) {
        this.app = Preconditions.checkNotNull(app);
        this.logger = Preconditions.checkNotNull(logger);
    }

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        this.logger.logf(Level.SEVERE, e, "Stopping because of uncaught exception.", new Object[0]);
        Thread shutdown = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    StopApplicationUncaughtExceptionHandler.this.app.stop();
                }
                catch (Throwable t) {
                    StopApplicationUncaughtExceptionHandler.this.logger.logf(Level.SEVERE, t, "Could not stop the client: %s", t.getMessage());
                    System.exit(2);
                }
            }
        });
        shutdown.setName("shutdown-thread");
        shutdown.start();
    }

    public Logger getLogger() {
        return this.logger;
    }
}

