/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.global.file_storage;

import com.google.common.hash.HashCode;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.sosy_lab.verifiercloud.global.file_storage.FileStorage;
import org.sosy_lab.verifiercloud.global.logging.MemoryLogger;
import org.sosy_lab.verifiercloud.global.processes.ProcessExecutor;
import org.sosy_lab.verifiercloud.transportable.filecontent.DefaultFileContent;
import org.sosy_lab.verifiercloud.transportable.filecontent.FileContent;

public abstract class AbstractFileStorageTestBase {
    private Path temporaryWorkingFolder;

    protected Path getTemporaryWorkingFolder() {
        return this.temporaryWorkingFolder;
    }

    @Before
    public void setUp() throws Exception {
        this.temporaryWorkingFolder = Files.createTempDirectory("vcloud-test-AbstractFileStorageTestBase", new FileAttribute[0]);
    }

    @After
    public void tearDown() throws Exception {
        ProcessExecutor pe = new ProcessExecutor(new MemoryLogger());
        pe.executeProcess("rm -r " + this.temporaryWorkingFolder);
    }

    @Test(expected=IllegalStateException.class)
    public void forgetInitialization() throws Exception {
        FileStorage<HashCode> fileStorage = this.getInstance();
        FileContent fileContent = this.createFileContent("some content");
        fileStorage.addFile(fileContent);
    }

    @Test
    public void addAndTest() throws Exception {
        FileStorage<HashCode> fileStorage = this.getInstance();
        fileStorage.initializeFileStorage(this.temporaryWorkingFolder);
        FileContent fileContent = this.createFileContent("some content");
        HashCode fileHash = fileStorage.addFile(fileContent);
        Assert.assertTrue((boolean)fileStorage.isFileKnown(fileHash));
    }

    @Test
    public void initializationAndIndexing() throws Exception {
        FileStorage<?> fileStorage1 = this.getNonBufferedInstance();
        fileStorage1.initializeFileStorage(this.temporaryWorkingFolder);
        FileContent fileContent = this.createFileContent("some content");
        HashCode fileHash = fileContent.getFileHash();
        fileStorage1.addFile(fileContent);
        FileStorage<HashCode> fileStorage2 = this.getIndexedInstance(this.temporaryWorkingFolder);
        Assert.assertTrue((boolean)fileStorage2.isFileKnown(fileHash));
    }

    public abstract FileStorage<HashCode> getInstance() throws IOException;

    public abstract FileStorage<HashCode> getIndexedInstance(Path var1) throws IOException;

    public abstract FileStorage<?> getNonBufferedInstance();

    protected FileContent createFileContent(String string) {
        return DefaultFileContent.fromString(string);
    }
}

