/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.global.file_storage;

import com.google.common.base.Preconditions;
import com.google.common.hash.HashCode;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.logging.Level;
import org.sosy_lab.verifiercloud.global.file_storage.GenericFileStorage;
import org.sosy_lab.verifiercloud.global.logging.Logger;
import org.sosy_lab.verifiercloud.global.util.FileUtils;
import org.sosy_lab.verifiercloud.global.util.HashUtils;
import org.sosy_lab.verifiercloud.transportable.filecontent.FileContent;
import org.sosy_lab.verifiercloud.transportable.units.memory.MemoryUnit;

public class DefaultGenericFileStorage
extends GenericFileStorage<Path> {
    private final boolean skipRehash;

    public DefaultGenericFileStorage(boolean skipRehash, Logger logger) {
        super(logger);
        this.skipRehash = skipRehash;
    }

    @Override
    protected void indexFile(Path file) throws IOException {
        HashCode fileHash;
        Preconditions.checkArgument(Files.isRegularFile(file, new LinkOption[0]));
        MemoryUnit fileSize = MemoryUnit.bytes(Files.size(file));
        HashCode fileNameHash = HashCode.fromString(file.getFileName().toString());
        if (this.skipRehash) {
            fileHash = fileNameHash;
        } else {
            fileHash = HashUtils.hashFile(file);
            if (!fileNameHash.equals(fileHash)) {
                this.logger.logf(Level.WARNING, "Deleting file %s not corresponding to its hash (%s).", file, fileHash);
                Files.delete(file);
                return;
            }
        }
        this.addFile(fileHash, file, fileSize);
    }

    public Path getFileFromStorage(HashCode fileHash) {
        return this.getPathFromStorage(fileHash);
    }

    @Override
    public Path addFile(FileContent fileContent) throws IOException {
        this.checkIsInitialized();
        Preconditions.checkNotNull(fileContent);
        HashCode fileHash = fileContent.getFileHash();
        String fileName = fileHash.toString();
        Path file = this.getFileDirectory().resolve(fileName);
        if (!Files.exists(file, new LinkOption[0])) {
            try {
                fileContent.writeToPath(file);
            }
            catch (IOException e) {
                FileUtils.deleteFileIfItExists(file);
                throw e;
            }
        }
        this.addFile(fileHash, file, fileContent.getFileSize());
        return file;
    }
}

