/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.global.file_storage;

import com.google.common.base.Preconditions;
import com.google.common.hash.HashCode;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.logging.Level;
import org.sosy_lab.verifiercloud.global.file_storage.GenericFileStorage;
import org.sosy_lab.verifiercloud.global.logging.Logger;
import org.sosy_lab.verifiercloud.global.util.FileUtils;
import org.sosy_lab.verifiercloud.transportable.filecontent.AbstractFileContent;
import org.sosy_lab.verifiercloud.transportable.filecontent.CorruptedFileException;
import org.sosy_lab.verifiercloud.transportable.filecontent.FileContent;
import org.sosy_lab.verifiercloud.transportable.units.memory.MemoryUnit;

public class RepresentationFileStorage
extends GenericFileStorage<HashCode> {
    private final boolean skipRehash;

    public RepresentationFileStorage(boolean skipRehash, Logger logger) {
        super(logger);
        this.skipRehash = skipRehash;
    }

    @Override
    protected void indexFile(Path file) throws IOException {
        Preconditions.checkArgument(Files.isRegularFile(file, new LinkOption[0]));
        if (this.skipRehash) {
            this.indexFileSkipRehash(file);
        } else {
            this.indexFileRehashing(file);
        }
    }

    private void indexFileRehashing(Path file) throws IOException {
        MemoryUnit fileSize;
        HashCode fileHash;
        try {
            FileContent fileContent = FileUtils.getFileContentFromRepresentation(file, false);
            fileHash = fileContent.getFileHash();
            fileSize = fileContent.getFileSize();
        }
        catch (IllegalArgumentException | CorruptedFileException e) {
            this.logger.logf(Level.WARNING, "Deleting corrupted file %s: %s.", file, e.getMessage());
            Files.delete(file);
            return;
        }
        this.addFile(fileHash, file, fileSize);
    }

    private void indexFileSkipRehash(Path file) throws IOException {
        MemoryUnit fileSize;
        HashCode fileHash;
        try {
            List<String> tokens = AbstractFileContent.getFileNameTokens(file);
            if (tokens.size() < 2 || tokens.size() > 3) {
                this.deleteCorruptedFile(file, "Invalid number of tokens in file name.");
                return;
            }
            fileHash = HashCode.fromString(tokens.get(0));
            long representationSize = Long.parseLong(tokens.get(1));
            if (representationSize != Files.size(file)) {
                this.deleteCorruptedFile(file, "Invalid file size " + Files.size(file) + ", expected " + representationSize + ".");
                return;
            }
            fileSize = tokens.size() == 2 ? MemoryUnit.bytes(representationSize) : MemoryUnit.fromString(tokens.get(2));
        }
        catch (IllegalArgumentException e) {
            this.deleteCorruptedFile(file, e.getMessage());
            return;
        }
        this.addFile(fileHash, file, fileSize);
    }

    private void deleteCorruptedFile(Path file, String message) throws IOException {
        this.logger.logf(Level.WARNING, "Deleting corrupted file %s: %s.", file, message);
        Files.delete(file);
    }

    public Path getFileRepresentationFromStorage(HashCode fileHash) {
        return this.getPathFromStorage(fileHash);
    }

    @Override
    public HashCode addFile(FileContent fileContent) throws IOException {
        Path file = fileContent.writeRepresentationToPath(this.getFileDirectory());
        this.addFile(fileContent.getFileHash(), file, fileContent.getFileSize());
        return fileContent.getFileHash();
    }
}

