/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.global.logging;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import org.sosy_lab.verifiercloud.global.logging.LevelMessagePair;
import org.sosy_lab.verifiercloud.global.logging.RuntimeLogger;

public class AsynchronousLogger
extends RuntimeLogger {
    private final RuntimeLogger logger;
    private final ExecutorService executionService;

    public AsynchronousLogger(RuntimeLogger logger) {
        this.logger = Preconditions.checkNotNull(logger);
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setDaemon(true).setNameFormat("Logging").build();
        this.executionService = Executors.newSingleThreadExecutor(threadFactory);
    }

    @Override
    void injectLogs(final List<LevelMessagePair> logEntries) {
        this.executionService.execute(new Runnable(){

            @Override
            public void run() {
                AsynchronousLogger.this.logger.injectLogs(logEntries);
            }
        });
    }

    @Override
    Level getLogLevel() {
        return this.logger.getLogLevel();
    }

    @Override
    public void logf(final Level logLevel, final Throwable cause, final String formatString, final Object ... args) {
        if (!this.wouldLog(logLevel)) {
            return;
        }
        final Date date = AsynchronousLogger.getCurrentDate();
        if (!this.executionService.isShutdown()) {
            this.executionService.execute(new Runnable(){

                @Override
                public void run() {
                    AsynchronousLogger.this.logger.log(logLevel, date, String.format(formatString, args), cause);
                }
            });
        }
    }

    @Override
    protected void log(final Level logLevel, final Date date, final String event, final Throwable t) {
        if (!this.executionService.isShutdown()) {
            this.executionService.execute(new Runnable(){

                @Override
                public void run() {
                    AsynchronousLogger.this.logger.log(logLevel, date, event, t);
                }
            });
        }
    }

    @Override
    public void close() throws IOException {
        this.executionService.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    AsynchronousLogger.this.logger.close();
                    AsynchronousLogger.this.executionService.shutdown();
                }
                catch (IOException e) {
                    System.err.println("Can not close logger: " + e.getMessage());
                }
            }
        });
    }
}

