/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.global.logging;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import org.sosy_lab.verifiercloud.global.logging.LevelMessagePair;
import org.sosy_lab.verifiercloud.global.logging.RuntimeLogger;

class CompositeLogger
extends RuntimeLogger {
    private final ImmutableList<RuntimeLogger> loggers;
    private final Level logLevel;

    CompositeLogger(Collection<RuntimeLogger> loggers) {
        Preconditions.checkArgument(!loggers.isEmpty(), "%s requires at least 1 logger.", this.getClass().getSimpleName());
        this.loggers = ImmutableList.copyOf(loggers);
        this.logLevel = this.highestLogLevel(this.loggers);
    }

    private Level highestLogLevel(Collection<RuntimeLogger> loggers) {
        Level logLevel = Level.OFF;
        for (RuntimeLogger logger : loggers) {
            if (logger.getLogLevel().intValue() >= logLevel.intValue()) continue;
            logLevel = logger.getLogLevel();
        }
        return logLevel;
    }

    @Override
    void injectLogs(List<LevelMessagePair> logEntries) {
        for (RuntimeLogger logger : this.loggers) {
            logger.injectLogs(logEntries);
        }
    }

    @Override
    Level getLogLevel() {
        return this.logLevel;
    }

    @Override
    protected void log(Level logLevel, Date date, String event, Throwable t) {
        for (RuntimeLogger logger : this.loggers) {
            logger.log(logLevel, date, event, t);
        }
    }

    @Override
    public void close() throws IOException {
        for (RuntimeLogger logger : this.loggers) {
            logger.close();
        }
    }
}

