/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.global.logging;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Level;
import java.util.zip.GZIPOutputStream;
import org.sosy_lab.verifiercloud.global.logging.PrintStreamLogger;

public class CompressingFileLogger
extends PrintStreamLogger {
    private static final String LOG_FILE_TIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS";

    CompressingFileLogger(Path logFile, Level logLevel) throws IOException {
        super(CompressingFileLogger.getPrintStream(logFile), logLevel);
    }

    private static PrintStream getPrintStream(Path logDir) throws IOException {
        return new PrintStream((OutputStream)new GZIPOutputStream(Files.newOutputStream(CompressingFileLogger.getLogFile(logDir), StandardOpenOption.WRITE, StandardOpenOption.CREATE_NEW), true), true, "UTF-8");
    }

    private static Path getLogFile(Path logDir) throws IOException {
        Files.createDirectories(logDir, new FileAttribute[0]);
        String formatedDate = new SimpleDateFormat(LOG_FILE_TIME_FORMAT).format(new Date());
        return logDir.resolve("Vcloud_" + formatedDate + ".log.gz");
    }
}

