/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.global.logging;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import org.sosy_lab.verifiercloud.global.logging.LevelMessagePair;
import org.sosy_lab.verifiercloud.global.logging.NullLogger;
import org.sosy_lab.verifiercloud.global.logging.RuntimeLogger;
import org.sosy_lab.verifiercloud.global.util.error_trigger.DefaultErrorTriggerExecutor;
import org.sosy_lab.verifiercloud.global.util.error_trigger.ErrorTriggerExecutor;

public class ErrorTriggerLogger
extends RuntimeLogger {
    private final Level logLevel;
    private final ErrorTriggerExecutor errorTriggerExecutor;

    public ErrorTriggerLogger(Level logLevel, Optional<String> errorTriggerCommand) {
        this.logLevel = Preconditions.checkNotNull(logLevel);
        this.errorTriggerExecutor = new DefaultErrorTriggerExecutor(errorTriggerCommand, new NullLogger());
    }

    @Override
    void injectLogs(List<LevelMessagePair> logEntries) {
    }

    @Override
    Level getLogLevel() {
        return this.logLevel;
    }

    @Override
    protected void log(Level logLevel, Date date, String event, Throwable t) {
        if (t != null) {
            this.errorTriggerExecutor.executeErrorTrigger(t, event);
        }
    }

    @Override
    public void close() throws IOException {
    }
}

