/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.global.logging;

import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Level;
import org.sosy_lab.verifiercloud.global.logging.PrintStreamLogger;

public class FileLogger
extends PrintStreamLogger {
    private static final String LOG_FILE_TIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS";

    FileLogger(Path logDir, Level logLevel) throws IOException {
        super(new PrintStream(Files.newOutputStream(FileLogger.getLogFile(logDir), StandardOpenOption.WRITE, StandardOpenOption.CREATE_NEW), false, "UTF-8"), logLevel);
    }

    private static Path getLogFile(Path logDir) throws IOException {
        Files.createDirectories(logDir, new FileAttribute[0]);
        String formatedDate = new SimpleDateFormat(LOG_FILE_TIME_FORMAT).format(new Date());
        return logDir.resolve("Vcloud_" + formatedDate + ".log");
    }
}

