/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.global.logging;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import org.sosy_lab.verifiercloud.global.logging.LevelMessagePair;
import org.sosy_lab.verifiercloud.global.logging.Logger;
import org.sosy_lab.verifiercloud.global.logging.RuntimeLogger;

public class InitialLogger
extends Logger {
    private RuntimeLogger actualLogger = null;
    private final List<LevelMessagePair> logMessages = Lists.newArrayList();

    InitialLogger() {
    }

    @Override
    public Level getLogLevel() {
        if (this.actualLogger != null) {
            return this.actualLogger.getLogLevel();
        }
        return Level.ALL;
    }

    @Override
    public void log(Level logLevel, Date date, String event, Throwable t) {
        if (this.actualLogger != null) {
            this.actualLogger.log(logLevel, date, event, t);
        } else {
            String message = InitialLogger.formatLog(date, event);
            this.logMessages.add(new LevelMessagePair(logLevel, message));
        }
    }

    @Override
    public void logf(Level logLevel, Throwable cause, String formatString, Object ... args) {
        if (this.actualLogger != null) {
            this.actualLogger.logf(logLevel, cause, formatString, args);
        } else {
            this.log(logLevel, InitialLogger.getCurrentDate(), String.format(formatString, args), cause);
        }
    }

    @Override
    public boolean wouldLog(Level level) {
        if (this.actualLogger != null) {
            return this.actualLogger.wouldLog(level);
        }
        return true;
    }

    public void setActualLogger(RuntimeLogger logger) {
        this.actualLogger = Preconditions.checkNotNull(logger);
        this.actualLogger.injectLogs(this.logMessages);
    }

    @Override
    public void close() throws IOException {
        if (this.actualLogger != null) {
            this.actualLogger.close();
        }
    }
}

