/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.global.logging;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Level;

public abstract class Logger {
    public static final String LOGLEVEL_ANNOTATION = "logLevel";
    public static final ImmutableList<String> POSSIBLE_SETTINGS = ImmutableList.of("SEVERE", "WARNING", "INFO", "CONFIG", "FINE", "FINER", "FINEST", "ALL");
    private static final String ISO_TIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ss";
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");

    abstract Level getLogLevel();

    public boolean wouldLog(Level level) {
        return level.intValue() >= this.getLogLevel().intValue();
    }

    protected abstract void log(Level var1, Date var2, String var3, Throwable var4);

    boolean isTraceEnabled() {
        return this.getLogLevel().intValue() <= Level.INFO.intValue();
    }

    public void logf(Level logLevel, String formatString, Object ... args) {
        this.logf(logLevel, null, formatString, args);
    }

    public abstract void logf(Level var1, Throwable var2, String var3, Object ... var4);

    public abstract void close() throws IOException;

    static Date getCurrentDate() {
        return new Date(System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String formatLog(Date time, String message) {
        String timeString;
        DateFormat dateFormat = DATE_FORMAT;
        synchronized (dateFormat) {
            timeString = DATE_FORMAT.format(time);
        }
        return timeString + ": " + message;
    }
}

