/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.global.logging;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.logging.Level;
import org.sosy_lab.verifiercloud.global.logging.AsynchronousLogger;
import org.sosy_lab.verifiercloud.global.logging.CompositeLogger;
import org.sosy_lab.verifiercloud.global.logging.CompressingFileLogger;
import org.sosy_lab.verifiercloud.global.logging.ErrorTriggerLogger;
import org.sosy_lab.verifiercloud.global.logging.FileLogger;
import org.sosy_lab.verifiercloud.global.logging.InitialLogger;
import org.sosy_lab.verifiercloud.global.logging.Logger;
import org.sosy_lab.verifiercloud.global.logging.NullLogger;
import org.sosy_lab.verifiercloud.global.logging.RuntimeLogger;
import org.sosy_lab.verifiercloud.global.logging.SystemErrorLogger;
import org.sosy_lab.verifiercloud.global.logging.SystemOutLogger;

public final class LoggerBuilder {
    private boolean async = false;
    private List<RuntimeLogger> loggers = Lists.newArrayList();

    private LoggerBuilder() {
    }

    public static InitialLogger createInitialLogger() {
        return new InitialLogger();
    }

    public static LoggerBuilder create() {
        return new LoggerBuilder();
    }

    private static boolean enablesLogging(Level logLevel) {
        return !logLevel.equals(Level.OFF);
    }

    public LoggerBuilder logToStdOut(Level logLevel) {
        if (LoggerBuilder.enablesLogging(logLevel)) {
            this.loggers.add(new SystemOutLogger(logLevel));
        }
        return this;
    }

    public LoggerBuilder logToStdError(Level logLevel) {
        if (LoggerBuilder.enablesLogging(logLevel)) {
            this.loggers.add(new SystemErrorLogger(logLevel));
        }
        return this;
    }

    public LoggerBuilder logToFile(Path file, Level logLevel) throws IOException {
        if (LoggerBuilder.enablesLogging(logLevel)) {
            this.loggers.add(new FileLogger(file, logLevel));
        }
        return this;
    }

    public LoggerBuilder logToCompressedFile(Path file, Level logLevel) throws IOException {
        if (LoggerBuilder.enablesLogging(logLevel)) {
            this.loggers.add(new CompressingFileLogger(file, logLevel));
        }
        return this;
    }

    public LoggerBuilder logExceptionsToErrorTrigger(Optional<String> errorTriggerCommand, Level logLevel) {
        if (LoggerBuilder.enablesLogging(logLevel) && errorTriggerCommand.isPresent()) {
            this.loggers.add(new ErrorTriggerLogger(logLevel, errorTriggerCommand));
        }
        return this;
    }

    public LoggerBuilder logAsynchronously() {
        this.async = true;
        return this;
    }

    private RuntimeLogger buildRuntimeLogger() {
        RuntimeLogger logger = this.loggers.isEmpty() ? new NullLogger() : (this.loggers.size() == 1 ? this.loggers.get(0) : new CompositeLogger(this.loggers));
        if (this.async) {
            return new AsynchronousLogger(logger);
        }
        return logger;
    }

    public Logger build() {
        return this.buildRuntimeLogger();
    }

    public void injectInto(InitialLogger logger) {
        logger.setActualLogger(this.buildRuntimeLogger());
    }
}

