/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.global.logging;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import org.sosy_lab.verifiercloud.global.logging.LevelMessagePair;
import org.sosy_lab.verifiercloud.global.logging.RuntimeLogger;

public class MemoryLogger
extends RuntimeLogger {
    private final List<LevelMessagePair> logMessages = Lists.newArrayList();

    public List<String> getLogs(Level minLevel) {
        Preconditions.checkNotNull(minLevel);
        ArrayList<String> filteredList = Lists.newArrayList();
        for (LevelMessagePair msg : this.logMessages) {
            if (!msg.isRelevant(minLevel)) continue;
            filteredList.add(msg.getMessage());
        }
        return filteredList;
    }

    @Override
    public Level getLogLevel() {
        return Level.ALL;
    }

    @Override
    public void log(Level logLevel, Date date, String event, Throwable t) {
        String message = MemoryLogger.formatLog(date, event);
        this.logMessages.add(new LevelMessagePair(logLevel, message));
    }

    @Override
    public boolean wouldLog(Level level) {
        return true;
    }

    @Override
    public void injectLogs(List<LevelMessagePair> logEntries) {
        this.logMessages.addAll(logEntries);
    }

    @Override
    public void close() throws IOException {
    }
}

