/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.global.logging;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import org.sosy_lab.verifiercloud.global.logging.LevelMessagePair;
import org.sosy_lab.verifiercloud.global.logging.RuntimeLogger;

abstract class PrintStreamLogger
extends RuntimeLogger {
    private final Level logLevel;
    private final PrintStream printStream;

    PrintStreamLogger(PrintStream printStream, Level logLevel) {
        this.printStream = Preconditions.checkNotNull(printStream);
        this.logLevel = Preconditions.checkNotNull(logLevel);
    }

    @Override
    public void log(Level eventLogLevel, Date date, String event, Throwable t) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(event));
        if (this.wouldLog(eventLogLevel)) {
            this.printStream.println(PrintStreamLogger.formatLog(date, event));
        }
        if (t != null && this.isTraceEnabled()) {
            t.printStackTrace(this.printStream);
        }
    }

    @Override
    public Level getLogLevel() {
        return this.logLevel;
    }

    @Override
    public void injectLogs(List<LevelMessagePair> logEntries) {
        for (LevelMessagePair logEntry : logEntries) {
            if (!this.wouldLog(logEntry.getLevel())) continue;
            this.printStream.println(logEntry.getMessage());
        }
    }

    @Override
    public void close() throws IOException {
        this.printStream.close();
    }
}

