/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.global.networking.establishing.connection_builder;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.io.IOException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.logging.Level;
import org.sosy_lab.verifiercloud.global.logging.Logger;
import org.sosy_lab.verifiercloud.global.networking.establishing.connection_builder.ConnectionBuilder;
import org.sosy_lab.verifiercloud.global.networking.establishing.connection_builder.ConnectionBuilderListener;

public class DefaultConnectionBuilder
implements ConnectionBuilder {
    private final String host;
    private final int port;
    private final Logger logger;
    private volatile Optional<Thread> connectThread = Optional.absent();
    private volatile boolean stopped = false;
    private static final int MAX_NUMBER_OF_RETRIES = 3;
    private static final int SLEEP_TIME_MILLISECONDS = 1000;

    @Inject
    public DefaultConnectionBuilder(@Named(value="connectionBuilderHost") String host, @Named(value="connectionBuilderPort") Integer port, Logger logger) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(host), "Host must not be empty.");
        Preconditions.checkArgument(!host.contains(" "), "Host must not contain whitespace: '%s'", host);
        this.host = host;
        Preconditions.checkArgument(port > 0);
        this.port = port;
        this.logger = logger;
    }

    @Override
    public void connect(ConnectionBuilderListener acceptor) {
        Thread thread = new Thread((Runnable)new ConnectToHost(acceptor), this.getClass().getSimpleName() + "-" + this.host + "-" + "-Thread");
        this.connectThread = Optional.of(thread);
        thread.start();
    }

    @Override
    public void stop() {
        this.stopped = true;
        if (this.connectThread.isPresent()) {
            this.connectThread.get().interrupt();
        }
    }

    @Override
    public String getMasterHostName() {
        return this.host;
    }

    @Override
    public int getMasterPort() {
        return this.port;
    }

    private final class ConnectToHost
    implements Runnable {
        private final ConnectionBuilderListener acceptor;

        public ConnectToHost(ConnectionBuilderListener acceptor) {
            this.acceptor = acceptor;
        }

        @Override
        public void run() {
            Optional<Object> connectionToServerSocket = Optional.absent();
            int numberOfConnectionAttempts = 0;
            while (numberOfConnectionAttempts < 3 && !connectionToServerSocket.isPresent()) {
                try {
                    Socket socket = new Socket(DefaultConnectionBuilder.this.host, DefaultConnectionBuilder.this.port);
                    connectionToServerSocket = Optional.of(socket);
                }
                catch (UnknownHostException e) {
                    this.connectionFailed("Cannot find server with address " + DefaultConnectionBuilder.this.host + ". Hostname unknown:" + e.getMessage());
                    return;
                }
                catch (IOException e) {
                    DefaultConnectionBuilder.this.logger.logf(Level.WARNING, "Connecting to master failed: %s", e.getMessage());
                }
                if (connectionToServerSocket.isPresent()) continue;
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    break;
                }
                ++numberOfConnectionAttempts;
            }
            if (connectionToServerSocket.isPresent() && !DefaultConnectionBuilder.this.stopped) {
                this.acceptor.acceptSocket((Socket)connectionToServerSocket.get());
            } else if (DefaultConnectionBuilder.this.stopped) {
                this.connectionFailed("Stopping connection task.");
            } else {
                this.connectionFailed("Connection to " + DefaultConnectionBuilder.this.host + ":" + DefaultConnectionBuilder.this.port + " cannot be established.");
            }
        }

        private void connectionFailed(String errorMessage) {
            this.acceptor.connectionFailed(DefaultConnectionBuilder.this.host, DefaultConnectionBuilder.this.port, errorMessage);
        }
    }
}

