/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.global.networking.interaction;

import com.google.common.base.Preconditions;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import org.sosy_lab.verifiercloud.global.logging.Logger;
import org.sosy_lab.verifiercloud.global.networking.interaction.API;
import org.sosy_lab.verifiercloud.global.networking.interaction.Command;
import org.sosy_lab.verifiercloud.global.networking.interaction.IncomingCommandHandler;
import org.sosy_lab.verifiercloud.global.networking.interaction.NetworkAbstraction;

public class AsyncIncomingCommandHandler<ConcreteAPI extends API>
implements IncomingCommandHandler<ConcreteAPI> {
    private final BlockingQueue<CommandAbstractionConnection<?>> incomingCommands = new LinkedBlockingQueue();
    private volatile AtomicBoolean active = new AtomicBoolean(false);
    private final Thread.UncaughtExceptionHandler uncaughtExceptionHandler;
    private final ConcreteAPI api;
    private final Logger logger;

    public AsyncIncomingCommandHandler(ConcreteAPI api, Thread.UncaughtExceptionHandler uncaughtExceptionHandler, Logger logger) {
        this.api = (API)Preconditions.checkNotNull(api);
        this.logger = Preconditions.checkNotNull(logger);
        this.uncaughtExceptionHandler = Preconditions.checkNotNull(uncaughtExceptionHandler);
    }

    @Override
    public void start() {
        Preconditions.checkState(!this.active.getAndSet(true));
        CommandHandlerRunnable messageThread = new CommandHandlerRunnable();
        Thread listeningThread = new Thread((Runnable)messageThread, this.getClass().getSimpleName() + "-" + this.api.getClass().getSimpleName() + "-" + "Thread");
        listeningThread.setUncaughtExceptionHandler(this.uncaughtExceptionHandler);
        listeningThread.start();
    }

    @Override
    public <A extends NetworkAbstraction<?, ?, ConcreteAPI>> boolean addCommand(A sender, Command<A, ? super ConcreteAPI> cmd) {
        boolean active = this.active.get();
        if (active) {
            this.incomingCommands.add(new CommandAbstractionConnection(this, sender, cmd));
        }
        return active;
    }

    @Override
    public void stop() {
        this.active.set(false);
    }

    private static class CommandAbstractionConnection<A extends NetworkAbstraction<?, ?, ConcreteAPI>> {
        private final Command<A, ? super ConcreteAPI> command;
        private final A sender;
        final /* synthetic */ AsyncIncomingCommandHandler this$0;

        public CommandAbstractionConnection(A abstraction, Command<A, ? super ConcreteAPI> command) {
            this.this$0 = var1_1;
            this.sender = abstraction;
            this.command = command;
        }

        private void applyAPI(ConcreteAPI api) {
            this.command.acceptAPI(this.sender, api);
        }

        public String toString() {
            return this.command.getClass().getSimpleName() + " from " + this.sender;
        }
    }

    private class CommandHandlerRunnable
    implements Runnable {
        private CommandHandlerRunnable() {
        }

        @Override
        public void run() {
            CommandAbstractionConnection cmd = null;
            while (AsyncIncomingCommandHandler.this.active.get()) {
                try {
                    cmd = (CommandAbstractionConnection)AsyncIncomingCommandHandler.this.incomingCommands.poll(1L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    continue;
                }
                if (cmd == null) continue;
                int queueSize = AsyncIncomingCommandHandler.this.incomingCommands.size();
                Level logLevel = queueSize > 5 ? Level.INFO : Level.ALL;
                AsyncIncomingCommandHandler.this.logger.logf(logLevel, "IncomingCommandHandler applies %s (%s in queue).", cmd, queueSize);
                cmd.applyAPI(AsyncIncomingCommandHandler.this.api);
            }
        }
    }
}

