/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.global.networking.interaction;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Socket;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import org.sosy_lab.verifiercloud.global.logging.Logger;
import org.sosy_lab.verifiercloud.global.networking.interaction.Command;
import org.sosy_lab.verifiercloud.global.networking.interaction.ConnectionListener;

public final class ConnectionHandler<CmdIn extends Command<?, ?>, CmdOut extends Command<?, ?>>
implements Runnable {
    private final Socket connection;
    private final String connectionIdentifier;
    private final ObjectOutputStream connectionWriter;
    private final ExecutorService messageWriterThread;
    private final Thread.UncaughtExceptionHandler exceptionHandler;
    private final Logger logger;
    private final List<ConnectionListener<? super CmdIn>> listeners = Lists.newArrayList();
    private final Class<CmdIn> networkMessageClass;
    private volatile boolean connectionShutDown = false;

    public ConnectionHandler(Socket connection, Logger logger, Thread.UncaughtExceptionHandler exceptionHandler, Class<CmdIn> networkMessageClass) {
        this.connection = Preconditions.checkNotNull(connection);
        String connectionIP = connection.getInetAddress().toString();
        this.connectionIdentifier = connectionIP + ":" + connection.getPort();
        this.logger = Preconditions.checkNotNull(logger);
        this.exceptionHandler = Preconditions.checkNotNull(exceptionHandler);
        ObjectOutputStream out = null;
        try {
            out = new ObjectOutputStream(connection.getOutputStream());
        }
        catch (IOException e) {
            logger.logf(Level.SEVERE, e, "Cannot initialize ObjectOutputStream on %s.", this.connectionIdentifier);
            this.closeConnection();
        }
        this.connectionWriter = out;
        this.networkMessageClass = Preconditions.checkNotNull(networkMessageClass);
        ThreadFactoryBuilder tfb = new ThreadFactoryBuilder();
        tfb.setNameFormat(this.toString() + "-writer-%d");
        tfb.setUncaughtExceptionHandler(exceptionHandler);
        this.messageWriterThread = Executors.newSingleThreadExecutor(tfb.build());
    }

    public synchronized void addListener(ConnectionListener<? super CmdIn> listener) {
        this.listeners.add(listener);
    }

    public void closeConnection() {
        this.closeConnectionNoWaiting();
        this.messageWriterThread.shutdownNow();
        try {
            this.messageWriterThread.awaitTermination(1L, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            this.logger.logf(Level.WARNING, e, "Interrupted while waiting for message writer thread.", new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeConnectionNoWaiting() {
        boolean closedHere = false;
        ConnectionHandler connectionHandler = this;
        synchronized (connectionHandler) {
            if (this.isConnected()) {
                this.connectionShutDown = true;
                closedHere = true;
                try {
                    this.connection.close();
                    this.logger.logf(Level.FINEST, "Connection to %s closed.", this.connectionIdentifier);
                }
                catch (IOException e) {
                    this.logger.logf(Level.FINE, "IOException when trying to close connection to %s: %s", this.connectionIdentifier, e.getMessage());
                }
            }
        }
        if (closedHere) {
            Thread listenersCaller = new Thread(new Runnable(){

                @Override
                public void run() {
                    for (ConnectionListener listener : ConnectionHandler.this.listeners) {
                        listener.connectionClosed();
                    }
                }
            }, this.toString() + "-listeners-caller");
            listenersCaller.setUncaughtExceptionHandler(this.exceptionHandler);
            listenersCaller.start();
        }
    }

    public synchronized boolean isConnected() {
        return !this.connectionShutDown && this.connection.isConnected();
    }

    public synchronized void writeMessage(CmdOut message) {
        if (this.connection.isOutputShutdown() || !this.isConnected() || this.messageWriterThread.isShutdown()) {
            this.logger.logf(Level.WARNING, "Cannot write message to %s.", this.connectionIdentifier);
            return;
        }
        this.messageWriterThread.execute(new MessageWriter(this, message));
    }

    @Override
    public void run() {
        this.readObjects();
        this.closeConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void readObjects() {
        ObjectInputStream ois = null;
        ConnectionHandler connectionHandler = this;
        synchronized (connectionHandler) {
            try {
                ois = new ObjectInputStream(this.connection.getInputStream());
            }
            catch (IOException e) {
                this.logger.logf(Level.INFO, "Cannot initialize SocketReader to %s: %s", this.connectionIdentifier, e.getMessage());
                return;
            }
        }
        try {
            Object receivedObject;
            block7: while ((receivedObject = ois.readObject()) != null) {
                this.logger.logf(Level.ALL, "Message from %s (%s)", this.connectionIdentifier, receivedObject);
                if (this.networkMessageClass.isInstance(receivedObject)) {
                    Command message = (Command)receivedObject;
                    Iterator<ConnectionListener<CmdIn>> i$ = this.listeners.iterator();
                    while (true) {
                        if (!i$.hasNext()) continue block7;
                        ConnectionListener<CmdIn> listener = i$.next();
                        listener.messageReceived(message);
                    }
                }
                this.logger.logf(Level.WARNING, "Received message of illegal type %s from %s", receivedObject.getClass().getName(), this.connectionIdentifier);
            }
            return;
        }
        catch (IOException e) {
            if (this.connectionShutDown) return;
            this.logger.logf(Level.FINEST, "Connection to %s lost.", this.connectionIdentifier);
            return;
        }
        catch (ClassNotFoundException e) {
            this.logger.logf(Level.WARNING, "Recevied object of unknown type %s from %s. This is pobably due to incomptabile versions.", e.getMessage(), this.connectionIdentifier);
        }
    }

    public String toString() {
        return String.format("%s[%s:%s]", this.getClass().getSimpleName(), this.connection.getRemoteSocketAddress(), this.connection.getPort());
    }

    private static class MessageWriter
    implements Runnable {
        private CmdOut message;
        final /* synthetic */ ConnectionHandler this$0;

        MessageWriter(CmdOut message) {
            this.this$0 = var1_1;
            this.message = message;
        }

        @Override
        public void run() {
            if (this.this$0.connection.isOutputShutdown() || !this.this$0.isConnected()) {
                this.this$0.logger.logf(Level.WARNING, "Cannot write message to %s.", this.this$0.connectionIdentifier);
                return;
            }
            try {
                this.this$0.logger.logf(Level.ALL, "Writing message to %s (%s)", this.this$0.connectionIdentifier, this.message.getClass());
                this.this$0.connectionWriter.writeObject(this.message);
                this.this$0.connectionWriter.reset();
            }
            catch (InvalidClassException | NotSerializableException e) {
                this.this$0.logger.logf(Level.SEVERE, "Cannot serialize object %s.", this.message.getClass().getCanonicalName());
                this.this$0.closeConnectionNoWaiting();
            }
            catch (IOException e) {
                this.this$0.logger.logf(Level.WARNING, "Cannot send message (IOError: %s) to %s.", e.getMessage(), this.this$0.connectionIdentifier);
                this.this$0.closeConnectionNoWaiting();
            }
        }
    }
}

