/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.global.networking.interaction;

import com.google.common.base.Preconditions;
import java.net.Socket;
import java.util.concurrent.atomic.AtomicBoolean;
import org.sosy_lab.verifiercloud.global.logging.Logger;
import org.sosy_lab.verifiercloud.global.networking.interaction.API;
import org.sosy_lab.verifiercloud.global.networking.interaction.Command;
import org.sosy_lab.verifiercloud.global.networking.interaction.ConnectionHandler;
import org.sosy_lab.verifiercloud.global.networking.interaction.ConnectionListener;

public abstract class NetworkAbstraction<CmdIn extends Command<?, ?>, CmdOut extends Command<?, ?>, APIIn extends API> {
    private final ConnectionHandler<CmdIn, CmdOut> connection;
    private final Thread connectionThread;
    private final AtomicBoolean isStarted = new AtomicBoolean(false);

    public NetworkAbstraction(Socket socket, Thread.UncaughtExceptionHandler exceptionHandler, Logger logger, Class<CmdIn> networkMsgInClass) {
        this.connection = new ConnectionHandler(Preconditions.checkNotNull(socket), Preconditions.checkNotNull(logger), Preconditions.checkNotNull(exceptionHandler), Preconditions.checkNotNull(networkMsgInClass));
        String threadName = "Communication-" + this.connection.getClass().getSimpleName() + "-" + this.connection.toString();
        this.connectionThread = new Thread(this.connection, threadName);
        this.connectionThread.setUncaughtExceptionHandler(exceptionHandler);
    }

    protected void addConnectionListener(ConnectionListener<? super CmdIn> listener) {
        Preconditions.checkNotNull(listener);
        this.connection.addListener(listener);
    }

    public boolean isAlive() {
        return this.connection.isConnected();
    }

    public final void sendCommand(CmdOut message) {
        Preconditions.checkNotNull(message);
        Preconditions.checkState(this.isStarted.get());
        this.connection.writeMessage(message);
    }

    public void startCommunication() {
        if (this.isStarted.getAndSet(true)) {
            throw new IllegalStateException(this.getClass() + " is already started.");
        }
        this.connectionThread.start();
    }

    public void terminateCommunication() {
        if (this.isStarted.get()) {
            this.connection.closeConnection();
        }
        boolean stopped = false;
        while (!stopped) {
            try {
                this.connectionThread.join();
                stopped = true;
            }
            catch (InterruptedException interruptedException) {}
        }
    }
}

