/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.global.networking.interaction;

import com.google.common.base.Preconditions;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import org.sosy_lab.verifiercloud.global.logging.Logger;
import org.sosy_lab.verifiercloud.global.networking.interaction.API;
import org.sosy_lab.verifiercloud.global.networking.interaction.Command;
import org.sosy_lab.verifiercloud.global.networking.interaction.IncomingCommandHandler;
import org.sosy_lab.verifiercloud.global.networking.interaction.NetworkAbstraction;

public class SyncIncomingCommandHandler<ConcreteAPI extends API>
implements IncomingCommandHandler<ConcreteAPI> {
    private final AtomicBoolean actvie = new AtomicBoolean(false);
    private final ConcreteAPI api;
    private final Logger logger;

    public SyncIncomingCommandHandler(ConcreteAPI api, Logger logger) {
        this.api = (API)Preconditions.checkNotNull(api);
        this.logger = Preconditions.checkNotNull(logger);
    }

    @Override
    public void start() {
        Preconditions.checkState(!this.actvie.getAndSet(true));
    }

    @Override
    public <A extends NetworkAbstraction<?, ?, ConcreteAPI>> boolean addCommand(A sender, Command<A, ? super ConcreteAPI> cmd) {
        if (this.actvie.get()) {
            this.logger.logf(Level.ALL, "IncomingCommandHandler applies %s to %s.", cmd, this.api.getClass().getSimpleName());
            cmd.acceptAPI(sender, this.api);
            return true;
        }
        return false;
    }

    @Override
    public void stop() {
        Preconditions.checkState(this.actvie.getAndSet(false));
    }
}

