/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.global.permanent_storage;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import org.sosy_lab.verifiercloud.global.logging.Logger;
import org.sosy_lab.verifiercloud.global.permanent_storage.FileCollector;
import org.sosy_lab.verifiercloud.global.permanent_storage.PermanentDirectory;
import org.sosy_lab.verifiercloud.global.permanent_storage.PermanentStorageUtil;
import org.sosy_lab.verifiercloud.global.permanent_storage.StorageFileParser;
import org.sosy_lab.verifiercloud.global.permanent_storage.exceptions.PermanentStorageException;
import org.sosy_lab.verifiercloud.global.permanent_storage.exceptions.PermanentStorageWriteException;

public class DefaultPermanentDirectory
implements PermanentDirectory {
    private final Path path;
    private final Logger logger;

    public static PermanentDirectory fromPath(Path configurationFilePath, Logger logger) {
        return new DefaultPermanentDirectory(configurationFilePath, logger);
    }

    private DefaultPermanentDirectory(Path configurationFilePath, Logger logger) {
        this.path = Preconditions.checkNotNull(configurationFilePath);
        Preconditions.checkArgument(Files.exists(this.path, new LinkOption[0]), "%s does not exist.", this.path);
        Preconditions.checkArgument(Files.isReadable(this.path) && Files.isWritable(this.path));
        this.logger = Preconditions.checkNotNull(logger);
    }

    @Override
    public <X> X parseFile(Path file, StorageFileParser<X> handler) throws PermanentStorageException {
        PermanentStorageUtil.parseFile(file, handler, this.logger);
        return handler.getParseResult();
    }

    @Override
    public Iterable<Path> getAllFiles() throws IOException {
        FileCollector fileCollector = new FileCollector();
        Files.walkFileTree(this.path, fileCollector);
        return fileCollector.getFiles();
    }

    @Override
    public void writeFile(Path relativeFilePath, String content) throws PermanentStorageWriteException {
        Preconditions.checkNotNull(relativeFilePath);
        Preconditions.checkNotNull(content);
        Preconditions.checkArgument(!relativeFilePath.isAbsolute(), "Given path is not relative");
        Path fullPath = this.path.resolve(relativeFilePath);
        Preconditions.checkArgument(!Files.exists(fullPath, new LinkOption[0]), "File does already exists.");
        try {
            Files.write(relativeFilePath, content.getBytes(Charsets.UTF_8), StandardOpenOption.CREATE_NEW);
        }
        catch (IOException e) {
            throw new PermanentStorageWriteException(e);
        }
    }
}

