/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.global.permanent_storage;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.UUID;
import java.util.logging.Level;
import org.sosy_lab.verifiercloud.global.logging.Logger;
import org.sosy_lab.verifiercloud.global.permanent_storage.DefaultPermanentDirectory;
import org.sosy_lab.verifiercloud.global.permanent_storage.PermanentDirectory;
import org.sosy_lab.verifiercloud.global.permanent_storage.PermanentStorage;
import org.sosy_lab.verifiercloud.global.permanent_storage.PermanentStorageUtil;
import org.sosy_lab.verifiercloud.global.permanent_storage.StorageFileParser;
import org.sosy_lab.verifiercloud.global.permanent_storage.exceptions.PermanentStorageException;
import org.sosy_lab.verifiercloud.global.permanent_storage.exceptions.PermanentStorageWriteException;

public class DefaultPermanentStorage
implements PermanentStorage {
    private final Path path;
    private final Logger logger;
    private boolean initialized = false;

    @Inject
    public DefaultPermanentStorage(@Named(value="permanentStoragePath") Path permanentStoragePath, Logger logger) {
        this.path = Preconditions.checkNotNull(permanentStoragePath);
        this.logger = Preconditions.checkNotNull(logger);
    }

    @Override
    public void initialize() throws PermanentStorageException {
        Preconditions.checkState(!this.initialized, "This storage is already initialized.");
        if (!Files.exists(this.path, new LinkOption[0])) {
            try {
                Files.createDirectories(this.path, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new PermanentStorageWriteException(e);
            }
        } else if (!Files.isDirectory(this.path, new LinkOption[0])) {
            throw new PermanentStorageException(this.path + " is not a directory.");
        }
        if (!Files.isReadable(this.path)) {
            throw new PermanentStorageException("Unable to read " + this.path);
        }
        if (!Files.isWritable(this.path)) {
            this.logger.logf(Level.WARNING, "Unable to write to %s.", this.path);
        }
        this.initialized = true;
        this.logger.logf(Level.FINE, "Permanent storage at %s initialized", this.path);
    }

    @Override
    public void parseFile(String fileName, StorageFileParser<?> handler) throws PermanentStorageException {
        Preconditions.checkState(this.initialized, "This storage is not initialized.");
        Preconditions.checkNotNull(fileName);
        Preconditions.checkArgument(Paths.get(fileName, new String[0]).getNameCount() == 1, "Invalid file name: %s", fileName);
        Path configurationFilePath = this.path.resolve(fileName);
        PermanentStorageUtil.parseFile(configurationFilePath, handler, this.logger);
    }

    @Override
    public <T> void write(String fileName, T content, StorageFileParser<T> parser) throws PermanentStorageException {
        Path targetFile = this.path.resolve(fileName);
        Path tmpFile = this.path.resolve(UUID.randomUUID().toString());
        try (OutputStream outputStream = Files.newOutputStream(tmpFile, StandardOpenOption.WRITE, StandardOpenOption.CREATE);){
            parser.write(outputStream, content);
            Files.move(tmpFile, targetFile, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
        }
        catch (IOException e) {
            throw new PermanentStorageException(e);
        }
    }

    @Override
    public PermanentDirectory getDirectory(String directoryName) throws PermanentStorageWriteException {
        Preconditions.checkState(this.initialized, "This storage is not initialized.");
        Path configurationFilePath = this.path.resolve(directoryName);
        if (!Files.exists(configurationFilePath, new LinkOption[0])) {
            try {
                Files.createDirectories(configurationFilePath, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new PermanentStorageWriteException(e);
            }
        }
        Preconditions.checkArgument(Files.isReadable(this.path) && Files.isWritable(this.path));
        Preconditions.checkArgument(Files.isDirectory(configurationFilePath, new LinkOption[0]));
        return DefaultPermanentDirectory.fromPath(configurationFilePath, this.logger);
    }
}

