/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.global.permanent_storage;

import com.google.common.io.CharSource;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.text.ParseException;
import java.util.logging.Level;
import org.sosy_lab.verifiercloud.global.logging.Logger;
import org.sosy_lab.verifiercloud.global.permanent_storage.StorageFileParser;
import org.sosy_lab.verifiercloud.global.permanent_storage.exceptions.PermanentStorageException;
import org.sosy_lab.verifiercloud.global.permanent_storage.exceptions.PermanentStorageReadException;
import org.sosy_lab.verifiercloud.global.permanent_storage.exceptions.PermanentStorageWriteException;

public class PermanentStorageUtil {
    private PermanentStorageUtil() {
    }

    public static void parseFile(Path file, StorageFileParser<?> handler, Logger logger) throws PermanentStorageException {
        if (!Files.exists(file, new LinkOption[0])) {
            try {
                OutputStream outputStream = Files.newOutputStream(file, StandardOpenOption.CREATE_NEW);
                handler.write(outputStream);
            }
            catch (IOException e) {
                throw new PermanentStorageWriteException(e);
            }
            logger.logf(Level.WARNING, "File %s does not exists in file storage. A default file was created.", file);
        }
        if (Files.exists(file, new LinkOption[0]) && Files.isRegularFile(file, new LinkOption[0])) {
            try {
                CharSource source = com.google.common.io.Files.asCharSource(file.toFile(), Charset.defaultCharset());
                handler.parse(source, file.toString());
            }
            catch (IOException | ParseException e) {
                throw new PermanentStorageReadException(e.getMessage());
            }
        } else {
            throw new IllegalArgumentException("Given path is not a regular file: " + file);
        }
    }
}

