/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.global.permanent_storage.configurations;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.Maps;
import com.google.common.io.CharSource;
import com.google.common.io.LineProcessor;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Map;
import java.util.logging.Level;
import org.sosy_lab.verifiercloud.global.logging.Logger;
import org.sosy_lab.verifiercloud.global.permanent_storage.ConfigurationHandler;
import org.sosy_lab.verifiercloud.global.permanent_storage.configurations.Configuration;
import org.sosy_lab.verifiercloud.global.permanent_storage.configurations.ConfigurationOption;

public abstract class AbstractConfigurationHandler<T extends Configuration>
implements ConfigurationHandler<T> {
    private final Logger logger;

    public AbstractConfigurationHandler(Logger logger) {
        this.logger = Preconditions.checkNotNull(logger);
    }

    protected abstract ImmutableCollection<ConfigurationOption<?>> getAllConfigurationOptions();

    @Override
    public final void write(OutputStream outputStream) throws IOException {
        PrintWriter writer = new PrintWriter(new OutputStreamWriter(outputStream, Charsets.UTF_8));
        ((Configuration)this.getParseResult()).write(writer);
        writer.flush();
    }

    @Override
    public final void write(OutputStream outputStream, T configuration) throws IOException {
        PrintWriter writer = new PrintWriter(new OutputStreamWriter(outputStream, Charsets.UTF_8));
        ((Configuration)configuration).write(writer);
        writer.flush();
    }

    protected final Map<ConfigurationOption<?>, String> parseConfig(CharSource source, String sourceName) throws IOException {
        ConfigLineProcessor lineProcessor = new ConfigLineProcessor(sourceName);
        source.readLines(lineProcessor);
        return lineProcessor.getResult();
    }

    private final class ConfigLineProcessor
    implements LineProcessor<Map<ConfigurationOption<?>, String>> {
        private final String sourceName;
        private Map<ConfigurationOption<?>, String> result = Maps.newHashMap();

        ConfigLineProcessor(String sourceName) {
            this.sourceName = sourceName;
        }

        @Override
        public boolean processLine(String line) throws IOException {
            if (!(line = line.trim()).startsWith("#") && !line.isEmpty()) {
                Iterable<String> keyValuePair = Splitter.on('=').trimResults().limit(2).split(line);
                if (FluentIterable.from(keyValuePair).size() != 2) {
                    AbstractConfigurationHandler.this.logger.logf(Level.WARNING, "Ignoring invalid entry in %s. Expected key-value pair, but got '%s'.", this.sourceName, line);
                    return true;
                }
                String keyToken = FluentIterable.from(keyValuePair).first().get();
                String valueToken = FluentIterable.from(keyValuePair).last().get();
                ConfigurationOption key = null;
                for (ConfigurationOption configurationOption : AbstractConfigurationHandler.this.getAllConfigurationOptions()) {
                    if (!configurationOption.getName().equals(keyToken)) continue;
                    key = configurationOption;
                    break;
                }
                if (key == null) {
                    AbstractConfigurationHandler.this.logger.logf(Level.WARNING, "Ignoring invalid option in %s: %s", this.sourceName, keyToken);
                } else {
                    if (this.result.containsKey(key)) {
                        throw new IOException("Multiple definitions of option '" + keyToken + "' in " + this.sourceName);
                    }
                    this.result.put(key, valueToken);
                }
            }
            return true;
        }

        @Override
        public Map<ConfigurationOption<?>, String> getResult() {
            return this.result;
        }
    }
}

