/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.global.permanent_storage.configurations;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.util.concurrent.UncheckedExecutionException;
import org.sosy_lab.verifiercloud.global.permanent_storage.configurations.ConfigurationOption;
import org.sosy_lab.verifiercloud.global.permanent_storage.configurations.StringFunction;
import org.sosy_lab.verifiercloud.global.permanent_storage.exceptions.InvalidOptionException;

public abstract class AbstractConfigurationOption<T>
implements ConfigurationOption<T> {
    public static final String PROPERTY_PREFIX = "vcloud.default.";
    private final String possibleOptions;
    private final String description;
    private final String name;
    private final T defaultValue;
    private final StringFunction<T> parsingFunction;
    private final Predicate<? super T> constraint;
    private T value;
    private final String annotation;

    public AbstractConfigurationOption(String name, String description, String possibleOptions, T defaultValue, StringFunction<T> parsingFunktion, Predicate<? super T> constraint, String annotation) {
        this.name = Preconditions.checkNotNull(name);
        this.annotation = Preconditions.checkNotNull(annotation);
        this.description = Preconditions.checkNotNull(description);
        this.possibleOptions = Preconditions.checkNotNull(possibleOptions);
        this.parsingFunction = Preconditions.checkNotNull(parsingFunktion);
        this.constraint = constraint;
        String propertyName = PROPERTY_PREFIX + name;
        String propertyValue = System.getProperty(propertyName);
        if (propertyValue != null) {
            try {
                this.defaultValue = parsingFunktion.fromString(propertyValue);
            }
            catch (InvalidOptionException e) {
                System.err.println(String.format("Invalid property %s=%s: %s", propertyName, propertyValue, e.getMessage()));
                throw new UncheckedExecutionException(e);
            }
        } else {
            this.defaultValue = defaultValue;
        }
        this.value = this.defaultValue;
    }

    protected String getAnnotation() {
        return this.annotation;
    }

    @Override
    public void setValue(String value) throws InvalidOptionException {
        this.value = this.parsingFunction.fromString(value);
        if (!this.constraint.apply(this.value)) {
            throw new InvalidOptionException("Constraint violation of the configuration option " + this.name + ".");
        }
    }

    @Override
    public String getPossibleOptions() {
        return this.possibleOptions;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public T getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public T getValue() {
        return this.value;
    }

    @Override
    public String getValueAsString() {
        return this.parsingFunction.toString(this.value);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ConfigurationOption)) {
            return false;
        }
        ConfigurationOption other = (ConfigurationOption)obj;
        return this.getName().equals(other.getName());
    }

    public String toString() {
        return this.getName();
    }
}

