/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.global.permanent_storage.configurations;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.inject.AbstractModule;
import com.google.inject.TypeLiteral;
import com.google.inject.binder.AnnotatedBindingBuilder;
import java.io.PrintWriter;
import org.sosy_lab.verifiercloud.global.permanent_storage.configurations.ConfigurationOption;
import org.sosy_lab.verifiercloud.global.permanent_storage.exceptions.InvalidOptionException;

public abstract class Configuration
extends AbstractModule {
    protected static void writeOption(PrintWriter writer, ConfigurationOption<?> option) {
        writer.printf("# %s%n", option.getDescription());
        writer.printf("# %s = %s%n", option.getName(), option.getPossibleOptions());
        writer.printf("%s = %s%n", option.getName(), option.getValueAsString());
        writer.println();
    }

    protected static String buildOptionsString(Iterable<ConfigurationOption<?>> options) {
        StringBuilder result = new StringBuilder();
        for (ConfigurationOption<?> option : options) {
            result.append("[");
            result.append("--");
            result.append(option.getName());
            result.append(" ");
            result.append(option.getPossibleOptions());
            result.append("] ");
        }
        return result.toString();
    }

    @Override
    protected <T> AnnotatedBindingBuilder<T> bind(Class<T> clazz) {
        return super.bind(clazz);
    }

    @Override
    protected <T> AnnotatedBindingBuilder<T> bind(TypeLiteral<T> typeLiteral) {
        return super.bind(typeLiteral);
    }

    @Override
    protected void configure() {
        for (ConfigurationOption configurationOption : this.getAllConfigurationOptions()) {
            configurationOption.bind(this);
        }
    }

    public void write(PrintWriter writer) {
        for (ConfigurationOption configurationOption : this.getAllConfigurationOptions()) {
            Configuration.writeOption(writer, configurationOption);
        }
    }

    public void set(ConfigurationOption<?> option, String value) throws InvalidOptionException {
        Preconditions.checkNotNull(option);
        Preconditions.checkNotNull(value);
        Preconditions.checkArgument(this.getAllConfigurationOptions().contains(option));
        option.setValue(value);
    }

    public abstract ImmutableSet<ConfigurationOption<?>> getAllConfigurationOptions();
}

