/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.global.permanent_storage.configurations;

import com.google.common.collect.ImmutableSet;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.sosy_lab.verifiercloud.global.permanent_storage.configurations.Configuration;
import org.sosy_lab.verifiercloud.global.permanent_storage.configurations.ConfigurationOption;
import org.sosy_lab.verifiercloud.global.permanent_storage.configurations.DefaultConfigurationBuilder;
import org.sosy_lab.verifiercloud.global.permanent_storage.exceptions.InvalidOptionException;

public abstract class ConfigurationTestBase {
    Configuration configuration;

    @Before
    public void setUp() {
        this.configuration = this.getDefaultConfigurationBuilder().getDefaultConfiguration();
    }

    protected abstract DefaultConfigurationBuilder<? extends Configuration> getDefaultConfigurationBuilder();

    @Test
    public void defaultValaueSetTest() throws InvalidOptionException {
        ImmutableSet<ConfigurationOption<?>> options = this.configuration.getAllConfigurationOptions();
        for (ConfigurationOption configurationOption : options) {
            Object initialValue = configurationOption.getValue();
            this.configuration.set(configurationOption, configurationOption.getValueAsString());
            Assert.assertEquals(initialValue, configurationOption.getValue());
        }
    }
}

