/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.global.permanent_storage.configurations;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.Sets;
import com.google.common.io.CharSource;
import java.io.IOException;
import java.text.ParseException;
import java.util.HashSet;
import java.util.Map;
import org.sosy_lab.verifiercloud.global.application.CommandLineArguments;
import org.sosy_lab.verifiercloud.global.logging.Logger;
import org.sosy_lab.verifiercloud.global.permanent_storage.configurations.AbstractConfigurationHandler;
import org.sosy_lab.verifiercloud.global.permanent_storage.configurations.Configuration;
import org.sosy_lab.verifiercloud.global.permanent_storage.configurations.ConfigurationOption;
import org.sosy_lab.verifiercloud.global.permanent_storage.configurations.DefaultConfigurationBuilder;
import org.sosy_lab.verifiercloud.global.permanent_storage.exceptions.InvalidOptionException;

public class DefaultConfigurationHandler<T extends Configuration>
extends AbstractConfigurationHandler<T> {
    private T configuration;

    public DefaultConfigurationHandler(DefaultConfigurationBuilder<T> configBuilder, Logger logger) {
        super(logger);
        this.configuration = (Configuration)configBuilder.getDefaultConfiguration();
    }

    @Override
    protected ImmutableCollection<ConfigurationOption<?>> getAllConfigurationOptions() {
        return ((Configuration)this.configuration).getAllConfigurationOptions();
    }

    @Override
    public void parse(CharSource source, String sourceName) throws ParseException, IOException {
        Map<ConfigurationOption<?>, String> permConfig;
        try {
            permConfig = super.parseConfig(source, sourceName);
        }
        catch (IOException e) {
            throw new ParseException(e.getMessage(), 0);
        }
        for (ConfigurationOption configurationOption : this.getAllConfigurationOptions()) {
            if (!permConfig.containsKey(configurationOption)) continue;
            String value = permConfig.get(configurationOption);
            try {
                ((Configuration)this.configuration).set(configurationOption, value);
            }
            catch (InvalidOptionException e) {
                throw new ParseException(e.getMessage(), 0);
            }
        }
    }

    @Override
    public CommandLineArguments claimParameters(CommandLineArguments commandlineParameters) throws InvalidOptionException {
        Map<String, String> namedArgs = commandlineParameters.getNamedArguments();
        HashSet<String> appliedParameterNames = Sets.newHashSet();
        for (ConfigurationOption configurationOption : this.getAllConfigurationOptions()) {
            if (!namedArgs.containsKey(configurationOption.getName())) continue;
            String value = namedArgs.get(configurationOption.getName());
            appliedParameterNames.add(configurationOption.getName());
            ((Configuration)this.configuration).set(configurationOption, value);
        }
        return commandlineParameters.removeNamedArguments(appliedParameterNames);
    }

    @Override
    public T getParseResult() {
        return this.configuration;
    }
}

