/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.global.permanent_storage.configurations;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.inject.name.Names;
import org.sosy_lab.verifiercloud.global.permanent_storage.configurations.AbstractConfigurationOption;
import org.sosy_lab.verifiercloud.global.permanent_storage.configurations.Configuration;
import org.sosy_lab.verifiercloud.global.permanent_storage.configurations.StringFunction;

public class DefaultConfigurationOption<T>
extends AbstractConfigurationOption<T> {
    private final Class<T> clazz;

    public DefaultConfigurationOption(String name, String description, String possibleOptions, T defaultValue, StringFunction<T> parsingFunction, Predicate<T> constraint, String annotation, Class<T> clazz) {
        super(name, description, possibleOptions, defaultValue, parsingFunction, constraint, annotation);
        this.clazz = Preconditions.checkNotNull(clazz);
    }

    public DefaultConfigurationOption(String name, String description, String possibleOptions, T defaultValue, StringFunction<T> parsingFunction, String annotation, Class<T> clazz) {
        this(name, description, possibleOptions, defaultValue, parsingFunction, Predicates.alwaysTrue(), annotation, clazz);
    }

    public DefaultConfigurationOption(String name, String description, String possibleOptions, T defaultValue, StringFunction<T> parsingFunction, Class<T> clazz) {
        this(name, description, possibleOptions, defaultValue, parsingFunction, name, clazz);
    }

    public DefaultConfigurationOption(String name, String description, String possibleOptions, T defaultValue, StringFunction<T> parsingFunction, String annotation) {
        this(name, description, possibleOptions, defaultValue, parsingFunction, annotation, defaultValue.getClass());
    }

    public DefaultConfigurationOption(String name, String description, String possibleOptions, T defaultValue, StringFunction<T> parsingFunction, Predicate<T> constraint, String annotation) {
        this(name, description, possibleOptions, defaultValue, parsingFunction, constraint, annotation, defaultValue.getClass());
    }

    public DefaultConfigurationOption(String name, String description, String possibleOptions, T defaultValue, StringFunction<T> parsingFunktion) {
        this(name, description, possibleOptions, defaultValue, parsingFunktion, name);
    }

    public DefaultConfigurationOption(String name, String description, String possibleOptions, T defaultValue, StringFunction<T> parsingFunktion, Predicate<T> constraint) {
        this(name, description, possibleOptions, defaultValue, parsingFunktion, constraint, name);
    }

    @Override
    public void bind(Configuration configuration) {
        String annotation = this.getAnnotation();
        Object value = this.getValue();
        configuration.bind(this.clazz).annotatedWith(Names.named(annotation)).toInstance(value);
    }
}

