/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.global.permanent_storage.configurations;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import org.sosy_lab.verifiercloud.global.permanent_storage.configurations.AbstractConfigurationOption;
import org.sosy_lab.verifiercloud.global.permanent_storage.configurations.Configuration;
import org.sosy_lab.verifiercloud.global.permanent_storage.configurations.StringFunction;

public class GenericTypeConfigurationOption<T>
extends AbstractConfigurationOption<T> {
    private final TypeLiteral<T> typeLiteral;

    public GenericTypeConfigurationOption(String name, String description, String possibleOptions, T defaultValue, StringFunction<T> parsingFunktion, Predicate<? super T> constraint, String annotation, TypeLiteral<T> typeLiteral) {
        super(name, description, possibleOptions, defaultValue, parsingFunktion, constraint, annotation);
        this.typeLiteral = Preconditions.checkNotNull(typeLiteral);
    }

    public GenericTypeConfigurationOption(String name, String description, String possibleOptions, T defaultValue, StringFunction<T> parsingFunktion, Predicate<? super T> constraint, TypeLiteral<T> typeLiteral) {
        this(name, description, possibleOptions, (T)defaultValue, (StringFunction<? super T>)parsingFunktion, constraint, name, (TypeLiteral<? super T>)typeLiteral);
    }

    public GenericTypeConfigurationOption(String name, String description, String possibleOptions, T defaultValue, StringFunction<T> parsingFunktion, TypeLiteral<T> typeLiteral) {
        this(name, description, possibleOptions, defaultValue, parsingFunktion, Predicates.alwaysTrue(), name, typeLiteral);
    }

    @Override
    public void bind(Configuration configuration) {
        Named anntotation = Names.named(this.getAnnotation());
        Object value = this.getValue();
        configuration.bind(this.typeLiteral).annotatedWith(anntotation).toInstance(value);
    }
}

