/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.global.permanent_storage.configurations.string_functions;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.sosy_lab.verifiercloud.global.permanent_storage.configurations.StringFunction;
import org.sosy_lab.verifiercloud.global.permanent_storage.exceptions.InvalidOptionException;

public class StringToImmutableListeFunction<T>
implements StringFunction<ImmutableList<T>> {
    private final StringFunction<T> elementStringFunction;
    private final String delimiter;

    public StringToImmutableListeFunction(StringFunction<T> elementStringFunction, String delimiter) {
        this.elementStringFunction = Preconditions.checkNotNull(elementStringFunction);
        this.delimiter = Preconditions.checkNotNull(delimiter);
        Preconditions.checkArgument(!delimiter.isEmpty());
    }

    @Override
    public ImmutableList<T> fromString(String input) throws InvalidOptionException {
        Preconditions.checkNotNull(input);
        ImmutableList.Builder values = ImmutableList.builder();
        Splitter splitter = Splitter.on(this.delimiter).trimResults().omitEmptyStrings();
        Iterable<String> tokens = splitter.split(input);
        for (String token : tokens) {
            values.add(this.elementStringFunction.fromString(token));
        }
        return values.build();
    }

    @Override
    public String toString(ImmutableList<T> input) {
        Preconditions.checkNotNull(input);
        ArrayList<String> partStrings = Lists.newArrayListWithCapacity(input.size());
        for (Object part : input) {
            partStrings.add(this.elementStringFunction.toString(part));
        }
        return Joiner.on(this.delimiter).join(partStrings);
    }
}

