/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.global.permanent_storage.configurations.string_functions;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.sosy_lab.verifiercloud.global.permanent_storage.configurations.StringFunction;
import org.sosy_lab.verifiercloud.global.permanent_storage.exceptions.InvalidOptionException;

public class StringToImmutableMapFunction<K, V>
implements StringFunction<ImmutableMap<K, V>> {
    private static final Splitter elementSplitter = Splitter.on(';').omitEmptyStrings().trimResults();
    private static final Splitter pairSplitter = Splitter.on('=').omitEmptyStrings().trimResults();
    private final StringFunction<K> keyFunction;
    private final StringFunction<V> valueFunction;

    public StringToImmutableMapFunction(StringFunction<K> keyFunction, StringFunction<V> valueFunction) {
        this.keyFunction = Preconditions.checkNotNull(keyFunction);
        this.valueFunction = Preconditions.checkNotNull(valueFunction);
    }

    @Override
    public ImmutableMap<K, V> fromString(String input) throws InvalidOptionException {
        LinkedHashMap<K, V> result = Maps.newLinkedHashMap();
        Iterable<String> tokens = elementSplitter.split(input);
        for (String token : tokens) {
            List<String> keyValueTokens = pairSplitter.splitToList(token);
            if (keyValueTokens.size() != 2) {
                throw new InvalidOptionException(keyValueTokens + "is not a valid key value pair.");
            }
            K key = this.keyFunction.fromString(keyValueTokens.get(0));
            V value = this.valueFunction.fromString(keyValueTokens.get(1));
            result.put(key, value);
        }
        return ImmutableMap.copyOf(result);
    }

    @Override
    public String toString(ImmutableMap<K, V> input) {
        ArrayList<String> partStrings = Lists.newArrayListWithCapacity(input.size());
        for (Map.Entry part : input.entrySet()) {
            String keyString = this.keyFunction.toString(part.getKey());
            String valueString = this.valueFunction.toString(part.getValue());
            partStrings.add(keyString + "=" + valueString);
        }
        return Joiner.on(";").join(partStrings);
    }
}

