/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.global.permanent_storage.configurations.string_functions;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import org.sosy_lab.verifiercloud.global.permanent_storage.configurations.StringFunction;
import org.sosy_lab.verifiercloud.global.permanent_storage.exceptions.InvalidOptionException;

public class StringToImmutableSetFunction<T>
implements StringFunction<ImmutableSet<T>> {
    private final StringFunction<T> elementStringFunction;
    private final String delimiter;

    public StringToImmutableSetFunction(StringFunction<T> elementStringFunction, String delimiter) {
        this.elementStringFunction = Preconditions.checkNotNull(elementStringFunction);
        this.delimiter = Preconditions.checkNotNull(delimiter);
        Preconditions.checkArgument(!delimiter.isEmpty());
    }

    @Override
    public ImmutableSet<T> fromString(String input) throws InvalidOptionException {
        Preconditions.checkNotNull(input);
        HashSet<T> values = Sets.newHashSet();
        Splitter splitter = Splitter.on(this.delimiter).trimResults().omitEmptyStrings();
        Iterable<String> tokens = splitter.split(input);
        for (String token : tokens) {
            values.add(this.elementStringFunction.fromString(token));
        }
        return ImmutableSet.copyOf(values);
    }

    @Override
    public String toString(ImmutableSet<T> input) {
        Preconditions.checkNotNull(input);
        ArrayList<String> partStrings = Lists.newArrayListWithCapacity(input.size());
        for (Object part : input) {
            partStrings.add(this.elementStringFunction.toString(part));
        }
        return Joiner.on(this.delimiter).join(partStrings);
    }
}

