/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.global.permanent_storage.configurations.string_functions;

import com.google.common.base.CharMatcher;
import com.google.common.base.Optional;
import com.google.common.base.Splitter;
import java.util.List;
import org.sosy_lab.verifiercloud.global.permanent_storage.configurations.StringFunction;
import org.sosy_lab.verifiercloud.global.permanent_storage.configurations.string_functions.StringToIntegerFunction;
import org.sosy_lab.verifiercloud.global.permanent_storage.configurations.string_functions.StringToMemoryUnitFunction;
import org.sosy_lab.verifiercloud.global.permanent_storage.configurations.string_functions.StringToOptionalFunction;
import org.sosy_lab.verifiercloud.global.permanent_storage.configurations.string_functions.StringToTimeIntervalFunction;
import org.sosy_lab.verifiercloud.global.permanent_storage.exceptions.InvalidOptionException;
import org.sosy_lab.verifiercloud.transportable.run.constraints.limitations.Limitations;
import org.sosy_lab.verifiercloud.transportable.run.constraints.limitations.LimitationsBuilder;
import org.sosy_lab.verifiercloud.transportable.units.memory.MemoryUnit;
import org.sosy_lab.verifiercloud.transportable.units.time.TimeInterval;

public class StringToLimitationsFunction
implements StringFunction<Limitations> {
    private static StringToTimeIntervalFunction timeIntervalFunction = new StringToTimeIntervalFunction();
    private static StringToOptionalFunction<MemoryUnit> memoryUnitFunction = new StringToOptionalFunction<MemoryUnit>(new StringToMemoryUnitFunction());
    private static StringToOptionalFunction<Integer> coreFunction = new StringToOptionalFunction<Integer>(new StringToIntegerFunction());

    @Override
    public Limitations fromString(String input) throws InvalidOptionException {
        if (!input.startsWith("(") || !input.endsWith(")")) {
            throw new InvalidOptionException("Limitations string musst be a tupple. Given is: " + input + ".");
        }
        Splitter splitter = Splitter.on(',').omitEmptyStrings().trimResults(CharMatcher.anyOf(" ()"));
        List<String> tokens = splitter.splitToList(input);
        if (tokens.size() != 3) {
            throw new InvalidOptionException("Limitations string musst be a triple. Given is: " + input + ".");
        }
        TimeInterval timeLimit = timeIntervalFunction.fromString(tokens.get(0));
        Object memoryLimit = memoryUnitFunction.fromString(tokens.get(1));
        Object coreLimit = coreFunction.fromString(tokens.get(2));
        LimitationsBuilder limitBuilder = LimitationsBuilder.from(timeLimit);
        if (((Optional)memoryLimit).isPresent()) {
            limitBuilder.setMemoryLimit((MemoryUnit)((Optional)memoryLimit).get());
        }
        if (((Optional)coreLimit).isPresent()) {
            limitBuilder.setCoreLimit((Integer)((Optional)coreLimit).get());
        }
        return limitBuilder.build();
    }

    @Override
    public String toString(Limitations input) {
        return "(" + timeIntervalFunction.toString(input.getTimeLimit()) + "," + memoryUnitFunction.toString(input.getMemoryLimit()) + "," + coreFunction.toString(input.getProcessorLimit()) + ")";
    }
}

