/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.global.permanent_storage.configurations.string_functions;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sosy_lab.verifiercloud.global.permanent_storage.configurations.StringFunction;
import org.sosy_lab.verifiercloud.global.permanent_storage.exceptions.InvalidOptionException;
import org.sosy_lab.verifiercloud.transportable.units.memory.MemoryUnit;

public class StringToMemoryUnitFunction
implements StringFunction<MemoryUnit> {
    private static final Pattern MEMORY_UNIT_PATTERN = Pattern.compile("^(\\d+)(|\\.\\d+) ?([kmg]?)((?<=k)ilo|(?<=m)ega|(?<=g)iga)?(b(ytes?)?)?$", 2);

    @Override
    public MemoryUnit fromString(String input) throws InvalidOptionException {
        Matcher matcher = MEMORY_UNIT_PATTERN.matcher(input);
        if (matcher.matches()) {
            String factorPrefix;
            long value = Long.parseLong(matcher.group(1));
            int decimalPart = 0;
            if (!matcher.group(2).isEmpty()) {
                String decimalPlaces = matcher.group(2).substring(1);
                if (decimalPlaces.length() > 3) {
                    throw new InvalidOptionException("Too many decimal places: " + input);
                }
                decimalPart = Integer.parseInt(decimalPlaces);
                switch (decimalPlaces.length()) {
                    case 1: {
                        decimalPart *= 100;
                        break;
                    }
                    case 2: {
                        decimalPart *= 10;
                    }
                }
            }
            switch (factorPrefix = matcher.group(3).toUpperCase()) {
                case "": 
                case "B": {
                    if (decimalPart != 0) {
                        throw new InvalidOptionException("You can't specify fractions of a byte: " + input);
                    }
                    return MemoryUnit.bytes(value);
                }
                case "K": {
                    if (decimalPart != 0) {
                        return MemoryUnit.bytes(value * 1000L + (long)decimalPart);
                    }
                    return MemoryUnit.kilobyte(value);
                }
                case "M": {
                    if (decimalPart != 0) {
                        return MemoryUnit.kilobyte(value * 1000L + (long)decimalPart);
                    }
                    return MemoryUnit.megabyte(value);
                }
                case "G": {
                    if (decimalPart != 0) {
                        return MemoryUnit.megabyte(value * 1000L + (long)decimalPart);
                    }
                    return MemoryUnit.gigabyte(value);
                }
            }
            throw new InvalidOptionException("Invalid memory amount: " + input);
        }
        throw new InvalidOptionException("Invalid memory amount: " + input);
    }

    @Override
    public String toString(MemoryUnit input) {
        return input.toString();
    }
}

