/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.global.permanent_storage.configurations.string_functions;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.HashSet;
import org.sosy_lab.verifiercloud.global.permanent_storage.configurations.StringFunction;
import org.sosy_lab.verifiercloud.global.permanent_storage.exceptions.InvalidOptionException;

public class StringToOptionalFunction<T>
implements StringFunction<Optional<T>> {
    private final StringFunction<T> stringFunction;
    private static final ImmutableSet<String> DEFAULT_ABSENT = ImmutableSet.of("", "-");
    private final ImmutableSet<String> absent;

    public StringToOptionalFunction(StringFunction<T> stringFunction) {
        this.stringFunction = Preconditions.checkNotNull(stringFunction);
        this.absent = DEFAULT_ABSENT;
    }

    public StringToOptionalFunction(StringFunction<T> stringFunction, String ... additionalAbsentValues) {
        this.stringFunction = Preconditions.checkNotNull(stringFunction);
        HashSet<String> absent = Sets.newHashSet(additionalAbsentValues);
        absent.addAll(DEFAULT_ABSENT);
        this.absent = ImmutableSet.copyOf(absent);
    }

    @Override
    public Optional<T> fromString(String input) throws InvalidOptionException {
        Preconditions.checkNotNull(input);
        if (this.absent.contains(input)) {
            return Optional.absent();
        }
        T value = this.stringFunction.fromString(input);
        return Optional.of(value);
    }

    @Override
    public String toString(Optional<T> input) {
        if (input.isPresent()) {
            return this.stringFunction.toString(input.get());
        }
        return "-";
    }
}

