/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.global.permanent_storage.configurations.string_functions;

import com.google.common.base.Splitter;
import java.util.List;
import java.util.regex.Pattern;
import org.sosy_lab.verifiercloud.client.applications.webclient.run_infomation.svn_revision.AllRevisionsSvnBranchPattern;
import org.sosy_lab.verifiercloud.client.applications.webclient.run_infomation.svn_revision.AllSvnBranches;
import org.sosy_lab.verifiercloud.client.applications.webclient.run_infomation.svn_revision.SvnBranchAndRevision;
import org.sosy_lab.verifiercloud.client.applications.webclient.run_infomation.svn_revision.SvnBranchHead;
import org.sosy_lab.verifiercloud.client.applications.webclient.run_infomation.svn_revision.SvnRevisionPattern;
import org.sosy_lab.verifiercloud.client.applications.webclient.run_infomation.svn_revision.SvnTag;
import org.sosy_lab.verifiercloud.global.permanent_storage.configurations.StringFunction;
import org.sosy_lab.verifiercloud.global.permanent_storage.exceptions.InvalidOptionException;

public class StringToSvnRevisionPatternFunction
implements StringFunction<SvnRevisionPattern> {
    private static final Splitter SPLITTER = Splitter.on(':').trimResults();
    private static final Splitter ALL_BRANCHES_SPLITTER = Splitter.on('-').trimResults();
    private static final Pattern ALL_BRANCHES = Pattern.compile("\\*:[0-9]*-HEAD");

    @Override
    public SvnRevisionPattern fromString(String input) throws InvalidOptionException {
        if (input.isEmpty()) {
            throw new InvalidOptionException("Empty svn revision string.");
        }
        List<String> tokens = SPLITTER.splitToList(input);
        if (tokens.size() == 1) {
            String tagName = tokens.get(0);
            return new SvnTag(tagName);
        }
        if (tokens.size() == 2) {
            String branchName = tokens.get(0);
            String revisionString = tokens.get(1);
            if (revisionString.equalsIgnoreCase("HEAD")) {
                return new SvnBranchHead(branchName);
            }
            if (revisionString.equals("*")) {
                return new AllRevisionsSvnBranchPattern(branchName);
            }
            if (ALL_BRANCHES.matcher(input).matches()) {
                List<String> revisionTokens = ALL_BRANCHES_SPLITTER.splitToList(revisionString);
                assert (revisionTokens.size() == 2);
                int revisionNumber = Integer.parseInt(revisionTokens.get(0));
                return new AllSvnBranches(revisionNumber);
            }
            int revisionNumber = Integer.parseInt(revisionString);
            return new SvnBranchAndRevision(branchName, revisionNumber);
        }
        throw new InvalidOptionException("Invalid number of tokens in svn revision representation.");
    }

    @Override
    public String toString(SvnRevisionPattern input) {
        return input.toString();
    }
}

