/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.global.permanent_storage.configurations.string_functions;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sosy_lab.verifiercloud.global.permanent_storage.configurations.StringFunction;
import org.sosy_lab.verifiercloud.global.permanent_storage.configurations.string_functions.StringToLongFunction;
import org.sosy_lab.verifiercloud.global.permanent_storage.exceptions.InvalidOptionException;
import org.sosy_lab.verifiercloud.transportable.units.time.TimeInterval;

public class StringToTimeIntervalFunction
implements StringFunction<TimeInterval> {
    private static final Pattern onlyNumbers = Pattern.compile(" *([0-9]+) *");
    private final StringToLongFunction intFunc = new StringToLongFunction();

    @Override
    public TimeInterval fromString(String input) throws InvalidOptionException {
        Matcher secondMatcher = onlyNumbers.matcher(input);
        if (secondMatcher.matches()) {
            return TimeInterval.seconds(Long.parseLong(secondMatcher.group(1)));
        }
        List<String> tokens = this.splitIntoTokens(input);
        long days = 0L;
        long hours = 0L;
        long minutes = 0L;
        long seconds = 0L;
        Iterator<String> it = tokens.iterator();
        block19: while (it.hasNext()) {
            String unit;
            long value;
            String nextString = it.next();
            try {
                value = Long.parseLong(nextString);
            }
            catch (NumberFormatException e) {
                throw new InvalidOptionException("Illegal token '" + nextString + "' in String '" + input + "'.");
            }
            if (!it.hasNext()) {
                throw new InvalidOptionException("Value " + nextString + " has no unit.");
            }
            switch (unit = it.next()) {
                case "day": 
                case "days": 
                case "d": {
                    if (days != 0L) {
                        throw new InvalidOptionException("Days set twice: " + unit);
                    }
                    days = value;
                    continue block19;
                }
                case "h": 
                case "hour": 
                case "hours": {
                    if (hours != 0L) {
                        throw new InvalidOptionException("Hours set twice: " + unit);
                    }
                    hours = value;
                    continue block19;
                }
                case "min": 
                case "m": {
                    if (minutes != 0L) {
                        throw new InvalidOptionException("Minutes set twice: " + unit);
                    }
                    minutes = value;
                    continue block19;
                }
                case "s": {
                    if (seconds != 0L) {
                        throw new InvalidOptionException("Seconds set twice: " + unit);
                    }
                    seconds = value;
                    continue block19;
                }
            }
            throw new InvalidOptionException("Unknown unit: " + unit);
        }
        return TimeInterval.sum(TimeInterval.seconds(seconds), TimeInterval.minutes(minutes), TimeInterval.hours(hours), TimeInterval.days(days));
    }

    private List<String> splitIntoTokens(String input) throws InvalidOptionException {
        ArrayList<String> tokens = Lists.newArrayList();
        CharType previous = CharType.BEGIN;
        int pos = 0;
        for (int i = 0; i <= input.length(); ++i) {
            CharType current;
            if (i == input.length()) {
                current = CharType.END;
            } else {
                char currentChar = input.charAt(i);
                if (Character.isLetter(currentChar)) {
                    current = CharType.LETTER;
                } else if (Character.isDigit(currentChar)) {
                    current = CharType.DIGIT;
                } else if (Character.isWhitespace(currentChar)) {
                    current = CharType.WHITESPACE;
                } else {
                    throw new InvalidOptionException("Unreconized character '" + currentChar + "' when parsing " + input);
                }
            }
            if (current == previous) continue;
            if (previous == CharType.LETTER || previous == CharType.DIGIT) {
                tokens.add(input.substring(pos, i));
            }
            if (current == CharType.LETTER || current == CharType.DIGIT) {
                pos = i;
            }
            previous = current;
        }
        return tokens;
    }

    @Override
    public String toString(TimeInterval input) {
        return this.intFunc.toString(input.toSeconds());
    }

    private static enum CharType {
        BEGIN,
        END,
        LETTER,
        DIGIT,
        WHITESPACE;

    }
}

