/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.global.processes;

import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.logging.Level;
import org.sosy_lab.verifiercloud.global.logging.Logger;
import org.sosy_lab.verifiercloud.global.processes.ProcessExecutionException;

public class ProcessExecutor {
    private final Logger logger;
    private final Runtime runtime = Runtime.getRuntime();

    public ProcessExecutor(Logger logger) {
        this.logger = logger;
    }

    public static final String escapeCommand(String originalCommand) {
        return originalCommand.replace("\\", "\\\\").replace("$", "\\$").replace("\"", "\\\"");
    }

    public String executeProcess(String command) throws ProcessExecutionException {
        ArrayList<String> inputLines = Lists.newArrayList();
        Process proc = null;
        try {
            String[] cmd = new String[]{"/bin/sh", "-c", command};
            proc = this.runtime.exec(cmd);
            try (BufferedReader r = new BufferedReader(new InputStreamReader(proc.getInputStream(), Charsets.UTF_8));){
                String line;
                while ((line = r.readLine()) != null) {
                    inputLines.add(line);
                }
            }
            int exitValue = proc.waitFor();
            if (exitValue != 0) {
                this.logger.logf(Level.WARNING, "Exit value of command '%s' was %d", command, exitValue);
                throw new ProcessExecutionException(exitValue);
            }
        }
        catch (IOException | InterruptedException e) {
            if (proc != null) {
                proc.destroy();
            }
            this.logger.logf(Level.SEVERE, e, "Problem while executing command '%s': %s", command, e.getMessage());
        }
        return Joiner.on("\n").join(inputLines);
    }
}

