/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.global.statistics;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.sosy_lab.verifiercloud.global.statistics.StatisticsCollector;

public class DefaultStatisticsCollector
implements StatisticsCollector {
    private final Multimap<String, Object> statistics = Multimaps.synchronizedListMultimap(ArrayListMultimap.create());
    private final Map<String, Integer> intStatistics = Collections.synchronizedMap(Maps.newHashMap());

    @Override
    public void set(String key, Object value) {
        this.statistics.replaceValues(key, Lists.newArrayList(value));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void increment(String key) {
        Map<String, Integer> map = this.intStatistics;
        synchronized (map) {
            Integer previousValue = this.intStatistics.get(key);
            if (previousValue == null) {
                previousValue = 0;
            }
            this.intStatistics.put(key, previousValue + 1);
        }
    }

    @Override
    public void add(String key, Object value) {
        this.statistics.put(key, value);
    }

    @Override
    public Iterable<String> getStatistics() {
        return Iterables.concat(this.getNonIntStatistics(), this.getIntStatistics());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<String> getNonIntStatistics() {
        ArrayList<String> result = Lists.newArrayList();
        Multimap<String, Object> multimap = this.statistics;
        synchronized (multimap) {
            for (String statisticName : this.statistics.keySet()) {
                StringBuilder builder = new StringBuilder();
                builder.append(statisticName).append(':');
                Collection<Object> values = this.statistics.get(statisticName);
                for (Object value : values) {
                    builder.append(' ').append(value.toString()).append(',');
                }
                builder.deleteCharAt(builder.length() - 1);
                result.add(builder.toString());
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<String> getIntStatistics() {
        ArrayList<String> result = Lists.newArrayList();
        Map<String, Integer> map = this.intStatistics;
        synchronized (map) {
            for (String statisticName : this.intStatistics.keySet()) {
                StringBuilder builder = new StringBuilder();
                builder.append(statisticName).append(": ");
                builder.append(this.intStatistics.get(statisticName));
                result.add(builder.toString());
            }
        }
        return result;
    }
}

