/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.global.util;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.logging.Level;
import org.sosy_lab.verifiercloud.global.logging.Logger;
import org.sosy_lab.verifiercloud.transportable.units.memory.MemoryUnit;

public class DirDeleter
implements FileVisitor<Path> {
    private final Logger logger;
    private long deletedFileSizeByte = 0L;

    public DirDeleter(Logger logger) {
        this.logger = Preconditions.checkNotNull(logger);
    }

    @Override
    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
        int hardLinkeCount = (Integer)Files.getAttribute(file, "unix:nlink", new LinkOption[0]);
        if (hardLinkeCount == 1) {
            this.deletedFileSizeByte += attrs.size();
        }
        Files.delete(file);
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
        this.logger.logf(Level.FINER, "Problem while deleting %s: %s", file, exc.getMessage());
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
        Files.delete(dir);
        return FileVisitResult.CONTINUE;
    }

    public MemoryUnit getDeletedFileSize() {
        return MemoryUnit.bytes(this.deletedFileSizeByte);
    }
}

