/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.global.util;

import com.google.common.base.Charsets;
import com.google.common.base.StandardSystemProperty;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.sosy_lab.verifiercloud.global.logging.Logger;
import org.sosy_lab.verifiercloud.global.util.DirDeleter;
import org.sosy_lab.verifiercloud.transportable.filecontent.BigFileContent;
import org.sosy_lab.verifiercloud.transportable.filecontent.BigZipFileContent;
import org.sosy_lab.verifiercloud.transportable.filecontent.CorruptedFileException;
import org.sosy_lab.verifiercloud.transportable.filecontent.DefaultFileContent;
import org.sosy_lab.verifiercloud.transportable.filecontent.EmptyFileContent;
import org.sosy_lab.verifiercloud.transportable.filecontent.FileContent;
import org.sosy_lab.verifiercloud.transportable.filecontent.ZipFileContent;
import org.sosy_lab.verifiercloud.transportable.units.memory.MemoryUnit;

public final class FileUtils {
    private static final String UNIX_NEWLINE = "\n";
    private static final long STRONG_COMPRESSION_LIMIT_BYTE = MemoryUnit.megabyte(25L).toByte();
    private static final Collection<String> COMPRESSED_FILE_ENDINGS = ImmutableSet.of("jar", "zip", "gz", "bz2", "hprof");
    private static final Collection<String> TEXT_FILE_ENDINGS = ImmutableSet.of("java", "py", "txt", "sh", "xml", "c", new String[]{"i"});

    public static PathMatcher getPathMatcherFromGlobPattern(String globPattern) {
        return FileSystems.getDefault().getPathMatcher("glob:" + globPattern);
    }

    public static void deleteFileIfItExists(Path pathToFile) throws IOException {
        block3: {
            if (Files.exists(pathToFile, new LinkOption[0])) {
                try {
                    Files.delete(pathToFile);
                }
                catch (IOException e) {
                    if (!Files.exists(pathToFile, new LinkOption[0])) break block3;
                    throw e;
                }
            }
        }
    }

    public static MemoryUnit deleteDirectory(Path dir, Logger logger) throws IOException {
        DirDeleter deleter = new DirDeleter(logger);
        Files.walkFileTree(dir, deleter);
        return deleter.getDeletedFileSize();
    }

    public static List<Path> recursiveFileList(Path start) throws IOException {
        final ArrayList<Path> result = Lists.newArrayList();
        Files.walkFileTree(start, (FileVisitor<? super Path>)new FileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                result.add(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                return null;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                return FileVisitResult.CONTINUE;
            }
        });
        return result;
    }

    public static FileContent getFileContentFromRepresentation(Path file, boolean skipRehashing) throws IOException, CorruptedFileException {
        long fileSizeByte = Files.size(file);
        if (fileSizeByte == 0L) {
            return EmptyFileContent.fromRepresentation(file);
        }
        String fileExtension = FileUtils.getExtension(file.getFileName().toString());
        if (fileExtension.equals("zip")) {
            if (fileSizeByte < STRONG_COMPRESSION_LIMIT_BYTE) {
                return ZipFileContent.fromRepresentation(file, skipRehashing);
            }
            return BigZipFileContent.fromRepresentation(file, skipRehashing);
        }
        if (fileSizeByte < STRONG_COMPRESSION_LIMIT_BYTE) {
            return DefaultFileContent.fromRepresentation(file, skipRehashing);
        }
        return BigFileContent.fromRepresentation(file, skipRehashing);
    }

    public static FileContent getFileContent(Path file) throws IOException {
        Path sourceFile;
        long fileSizeByte = Files.size(file);
        String fileExtension = FileUtils.getExtension(file.getFileName().toString());
        if (COMPRESSED_FILE_ENDINGS.contains(fileExtension)) {
            if (fileSizeByte < STRONG_COMPRESSION_LIMIT_BYTE) {
                return DefaultFileContent.fromPath(file);
            }
            return BigFileContent.fromPath(file);
        }
        boolean temporaryFile = false;
        if (StandardSystemProperty.OS_NAME.value().startsWith("Win") && TEXT_FILE_ENDINGS.contains(fileExtension)) {
            sourceFile = FileUtils.createTemporaryfileWithUnixLineEndings(file);
            temporaryFile = true;
        } else {
            sourceFile = file;
        }
        FileContent fileContent = null;
        fileContent = fileSizeByte == 0L ? new EmptyFileContent() : (fileSizeByte < STRONG_COMPRESSION_LIMIT_BYTE ? ZipFileContent.fromPath(sourceFile, -1) : BigZipFileContent.fromPath(sourceFile, true));
        if (temporaryFile) {
            Files.delete(sourceFile);
        }
        return fileContent;
    }

    private static Path createTemporaryfileWithUnixLineEndings(Path file) throws IOException {
        Path linuxFile = Files.createTempFile("vcloud-FileUtils-createTemporaryfileWithUnixLineEndings", ".tmp", new FileAttribute[0]);
        try (BufferedReader r = Files.newBufferedReader(file, Charsets.UTF_8);
             BufferedWriter w = Files.newBufferedWriter(linuxFile, Charsets.UTF_8, new OpenOption[0]);){
            String line = r.readLine();
            while (line != null) {
                w.write(line);
                w.write(UNIX_NEWLINE);
                line = r.readLine();
            }
        }
        return linuxFile;
    }

    private static String getExtension(String fileName) {
        int indexOfPoint = fileName.lastIndexOf(46);
        if (indexOfPoint > 0) {
            return fileName.substring(indexOfPoint + 1);
        }
        return "";
    }
}

